/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.io.BufferSink;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.MimeType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Builder;

public abstract class RequestBody {
    public static RequestBody create(MimeType contentType, String content) {
        java.nio.charset.Charset charset = Charset.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = Charset.UTF_8;
            contentType = MimeType.valueOf(contentType + "; charset=utf-8");
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(contentType, bytes);
    }

    public static RequestBody create(final MimeType contentType, final ByteString content) {
        return new RequestBody(){

            @Override
            public MimeType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return content.size();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody create(MimeType contentType, byte[] content) {
        return RequestBody.create(contentType, content, 0, content.length);
    }

    public static RequestBody create(final MimeType contentType, final byte[] content, final int offset, final int byteCount) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        Builder.checkOffsetAndCount(content.length, offset, byteCount);
        return new RequestBody(){

            @Override
            public MimeType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return byteCount;
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
    }

    public static RequestBody create(final MimeType contentType, final File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Override
            public MimeType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                Source source = null;
                try {
                    source = IoKit.source(file);
                    sink.writeAll(source);
                }
                finally {
                    IoKit.close(source);
                }
            }
        };
    }

    public abstract MimeType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferSink var1) throws IOException;
}

