/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.IOException;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.BufferSource;
import org.aoju.bus.core.io.DelegateSource;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.lang.MimeType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.magic.ProgressListener;
import org.aoju.bus.http.metric.Interceptor;

public abstract class FileInterceptor
implements Interceptor,
ProgressListener {
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response rsp = chain.proceed(chain.request());
        return rsp.newBuilder().body(new DownloadFileProgressResponseBody(rsp.body(), this)).build();
    }

    @Override
    public abstract void updateProgress(long var1, long var3, boolean var5);

    public static class DownloadFileProgressResponseBody
    extends ResponseBody {
        private final ResponseBody body;
        private final ProgressListener progressListener;
        private BufferSource bufferedSource;

        public DownloadFileProgressResponseBody(ResponseBody body, ProgressListener progressListener) {
            this.body = body;
            this.progressListener = progressListener;
        }

        @Override
        public MimeType contentType() {
            return this.body.contentType();
        }

        @Override
        public long contentLength() {
            return this.body.contentLength();
        }

        @Override
        public BufferSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = IoKit.buffer(this.source(this.body.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new DelegateSource(source){
                long downloadLenth;
                {
                    super(x0);
                    this.downloadLenth = 0L;
                }

                @Override
                public long read(Buffer sink, long byteCount) throws IOException {
                    boolean isFinish;
                    long bytesRead = super.read(sink, byteCount);
                    boolean bl = isFinish = bytesRead == -1L;
                    if (!isFinish) {
                        this.downloadLenth += bytesRead;
                    }
                    progressListener.updateProgress(this.downloadLenth, body.contentLength(), isFinish);
                    return bytesRead;
                }
            };
        }
    }
}

