/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.acquire;

import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.acquire.DeviceExtension;
import org.aoju.bus.image.metric.internal.hl7.ERRSegment;
import org.aoju.bus.image.metric.internal.hl7.HL7Application;
import org.aoju.bus.image.metric.internal.hl7.HL7ConnectionMonitor;
import org.aoju.bus.image.metric.internal.hl7.HL7Exception;
import org.aoju.bus.image.metric.internal.hl7.HL7Handler;
import org.aoju.bus.image.metric.internal.hl7.HL7MessageListener;
import org.aoju.bus.image.metric.internal.hl7.UnparsedHL7Message;

public class HL7DeviceExtension
extends DeviceExtension {
    private final LinkedHashMap<String, HL7Application> hl7apps = new LinkedHashMap();
    private transient HL7MessageListener hl7MessageListener;
    private transient HL7ConnectionMonitor hl7ConnectionMonitor;

    @Override
    public void verifyNotUsed(Connection conn) {
        for (HL7Application app : this.hl7apps.values()) {
            if (!app.getConnections().contains(conn)) continue;
            throw new IllegalStateException(conn + " used by HL7 Application: " + app.getApplicationName());
        }
    }

    public void addHL7Application(HL7Application hl7App) {
        hl7App.setDevice(this.device);
        this.hl7apps.put(hl7App.getApplicationName(), hl7App);
    }

    public HL7Application removeHL7Application(String name) {
        HL7Application hl7App = (HL7Application)this.hl7apps.remove(name);
        if (hl7App != null) {
            hl7App.setDevice(null);
        }
        return hl7App;
    }

    public boolean removeHL7Application(HL7Application hl7App) {
        return this.removeHL7Application(hl7App.getApplicationName()) != null;
    }

    public HL7Application getHL7Application(String name) {
        return this.hl7apps.get(name);
    }

    public HL7Application getHL7Application(String name, boolean matchOtherAppNames) {
        HL7Application app = this.hl7apps.get(name);
        if (app == null) {
            app = this.hl7apps.get("*");
        }
        if (app == null && matchOtherAppNames) {
            for (HL7Application app1 : this.getHL7Applications()) {
                if (!app1.isOtherApplicationName(name)) continue;
                return app1;
            }
        }
        return app;
    }

    public boolean containsHL7Application(String name) {
        return this.hl7apps.containsKey(name);
    }

    public Collection<String> getHL7ApplicationNames() {
        return this.hl7apps.keySet();
    }

    public Collection<HL7Application> getHL7Applications() {
        return this.hl7apps.values();
    }

    public final HL7MessageListener getHL7MessageListener() {
        return this.hl7MessageListener;
    }

    public final void setHL7MessageListener(HL7MessageListener listener) {
        this.hl7MessageListener = listener;
    }

    public HL7ConnectionMonitor getHL7ConnectionMonitor() {
        return this.hl7ConnectionMonitor;
    }

    public void setHL7ConnectionMonitor(HL7ConnectionMonitor hl7ConnectionMonitor) {
        this.hl7ConnectionMonitor = hl7ConnectionMonitor;
    }

    public UnparsedHL7Message onMessage(Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        HL7Application hl7App = this.getHL7Application(msg.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            throw new HL7Exception(new ERRSegment(msg.msh()).setHL7ErrorCode("103").setErrorLocation("MSH^1^5").setUserMessage("Receiving Application not recognized"));
        }
        return hl7App.onMessage(conn, s, msg);
    }

    @Override
    public void reconfigure(DeviceExtension from) {
        this.reconfigureHL7Applications((HL7DeviceExtension)from);
    }

    private void reconfigureHL7Applications(HL7DeviceExtension from) {
        this.hl7apps.keySet().retainAll(from.hl7apps.keySet());
        for (HL7Application src : from.hl7apps.values()) {
            HL7Application hl7app = this.hl7apps.get(src.getApplicationName());
            if (hl7app == null) {
                hl7app = new HL7Application(src.getApplicationName());
                this.addHL7Application(hl7app);
            }
            hl7app.reconfigure(src);
        }
    }

    static {
        Connection.registerTCPProtocolHandler(Connection.Protocol.HL7, HL7Handler.INSTANCE);
    }
}

