/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.image.galaxy.Property;

public class IdentityRQ {
    public static final int USERNAME = 1;
    public static final int USERNAME_PASSCODE = 2;
    public static final int KERBEROS = 3;
    public static final int SAML = 4;
    private static final String[] TYPES = new String[]{"0", "1 - Username", "2 - Username and passcode", "3 - Kerberos Service ticket", "4 - SAML Assertion"};
    private final int type;
    private final boolean rspReq;
    private final byte[] primaryField;
    private final byte[] secondaryField;

    public IdentityRQ(int type, boolean rspReq, byte[] primaryField, byte[] secondaryField) {
        this.type = type;
        this.rspReq = rspReq;
        this.primaryField = (byte[])primaryField.clone();
        this.secondaryField = secondaryField != null ? (byte[])secondaryField.clone() : new byte[]{};
    }

    public IdentityRQ(int type, boolean rspReq, byte[] primaryField) {
        this(type, rspReq, primaryField, null);
    }

    public IdentityRQ(String username, char[] passcode) {
        this(2, true, IdentityRQ.toBytes(username), IdentityRQ.toBytes(new String(passcode)));
    }

    public IdentityRQ(String username, boolean rspReq) {
        this(1, rspReq, IdentityRQ.toBytes(username));
    }

    private static String typeAsString(int type) {
        try {
            return TYPES[type];
        }
        catch (IndexOutOfBoundsException e) {
            return Integer.toString(type);
        }
    }

    private static byte[] toBytes(String s) {
        return s.getBytes(Charset.UTF_8);
    }

    private static String toString(byte[] b) {
        return new String(b, Charset.UTF_8);
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isPositiveResponseRequested() {
        return this.rspReq;
    }

    public final byte[] getPrimaryField() {
        return (byte[])this.primaryField.clone();
    }

    public final byte[] getSecondaryField() {
        return (byte[])this.secondaryField.clone();
    }

    public final String getUsername() {
        return IdentityRQ.toString(this.primaryField);
    }

    public final char[] getPasscode() {
        return IdentityRQ.toString(this.secondaryField).toCharArray();
    }

    public int length() {
        return 6 + this.primaryField.length + this.secondaryField.length;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder sb) {
        sb.append("  UserIdentity[").append(Property.LINE_SEPARATOR).append("    type: ").append(IdentityRQ.typeAsString(this.type)).append(Property.LINE_SEPARATOR);
        if (this.type == 1 || this.type == 2) {
            sb.append("    username: ").append(this.getUsername());
        } else {
            sb.append("    primaryField: byte[").append(this.primaryField.length).append(']');
        }
        if (this.type == 2) {
            sb.append(Property.LINE_SEPARATOR).append("    passcode: ");
            int i = this.secondaryField.length;
            while (--i >= 0) {
                sb.append('*');
            }
        } else if (this.secondaryField.length > 0) {
            sb.append(Property.LINE_SEPARATOR).append("    secondaryField: byte[").append(this.secondaryField.length).append(']');
        }
        return sb.append(Property.LINE_SEPARATOR).append("  ]");
    }
}

