/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.tinylog;

import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public class TinyLog
extends AbstractAware {
    private static final int DEPTH = 5;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
    private final int level;
    private final String name;

    public TinyLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public TinyLog(String name) {
        this.name = name;
        this.level = provider.getMinimumLevel().ordinal();
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayKit.isNotEmpty(arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTrace() {
        return this.level <= Level.TRACE.ordinal();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.level <= Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.level <= Level.INFO.ordinal();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.level <= Level.WARN.ordinal();
    }

    @Override
    public boolean isError() {
        return this.level <= Level.ERROR.ordinal();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, this.toTinyLevel(level), t, format, arguments);
    }

    @Override
    public boolean isEnabled(org.aoju.bus.logger.level.Level level) {
        return this.level <= this.toTinyLevel(level).ordinal();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.WARN, t, format, arguments);
    }

    private void logIfEnabled(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (null == t) {
            t = TinyLog.getLastArgumentIfThrowable(arguments);
        }
        provider.log(5, null, level, t, formatter, (Object)StringKit.toString(format), arguments);
    }

    private Level toTinyLevel(org.aoju.bus.logger.level.Level level) {
        Level tinyLevel;
        switch (level) {
            case TRACE: {
                tinyLevel = Level.TRACE;
                break;
            }
            case DEBUG: {
                tinyLevel = Level.DEBUG;
                break;
            }
            case INFO: {
                tinyLevel = Level.INFO;
                break;
            }
            case WARN: {
                tinyLevel = Level.WARN;
                break;
            }
            case ERROR: {
                tinyLevel = Level.ERROR;
                break;
            }
            case OFF: {
                tinyLevel = Level.OFF;
                break;
            }
            default: {
                throw new Error(StringKit.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        return tinyLevel;
    }
}

