/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShape;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.XComponentContext;
import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.bridge.LocalOfficeContextAware;
import org.aoju.bus.office.magic.Info;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Props;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.FilterChain;
import org.aoju.bus.office.magic.filter.text.AbstractTextContentInserterFilter;

public class GraphicInserterFilter
extends AbstractTextContentInserterFilter {
    private final String imagePath;

    public GraphicInserterFilter(String imagePath, int horizontalPosition, int verticalPosition) throws InstrumentException {
        super(GraphicInserterFilter.getImageSize(new File(imagePath)), horizontalPosition, verticalPosition);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, int width, int height, Map<String, Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, Map<String, Object> shapeProperties) throws InstrumentException {
        super(GraphicInserterFilter.getImageSize(new File(imagePath)), shapeProperties);
        this.imagePath = imagePath;
    }

    /*
     * Exception decompiling
     */
    private static Dimension getImageSize(File image) throws InstrumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int pixelsToMillimeters(int pixels) {
        return Math.round((float)pixels * 0.26458332f);
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            this.insertGraphic(((LocalOfficeContextAware)context).getComponentContext(), document);
        }
        chain.doFilter(context, document);
    }

    private void insertGraphic(XComponentContext context, XComponent document) throws Exception {
        XMultiServiceFactory serviceFactory = Lo.getServiceFactory(document);
        Object graphicShape = serviceFactory.createInstance("com.sun.star.drawing.GraphicObjectShape");
        XShape shape = Lo.qi(XShape.class, graphicShape);
        shape.setSize(GraphicInserterFilter.toOfficeSize(this.getRectSize()));
        File sourceFile = new File(this.imagePath);
        String strUrl = Builder.toUrl(sourceFile);
        XPropertySet propSet = Lo.qi(XPropertySet.class, graphicShape);
        if (Info.isLibreOffice(context) && Info.compareVersions("6.1", Info.getOfficeVersionShort(context), 2) >= 0) {
            XGraphicProvider graphicProvider = Lo.createInstanceMCF(context, XGraphicProvider.class, "com.sun.star.graphic.GraphicProvider");
            propSet.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(Props.makeProperties("URL", strUrl, "LoadAsLink", false)));
        } else {
            XNameContainer bitmapContainer = Lo.createInstanceMSF(serviceFactory, XNameContainer.class, "com.sun.star.drawing.BitmapTable");
            String string = UUID.randomUUID().toString();
            bitmapContainer.insertByName(string, (Object)strUrl);
            propSet.setPropertyValue("GraphicURL", bitmapContainer.getByName(string));
        }
        for (Map.Entry entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue((String)entry.getKey(), entry.getValue());
        }
        XTextDocument docText = Write.getTextDoc(document);
        XText xText = docText.getText();
        XTextCursor textCursor = xText.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        XTextContent textContent = Lo.qi(XTextContent.class, graphicShape);
        xText.insertTextContent((XTextRange)textCursor, textContent, false);
    }
}

