/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XComponent;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class PageMarginsFilter
implements Filter {
    private final Integer topMargin;
    private final Integer rightMargin;
    private final Integer bottomMargin;
    private final Integer leftMargin;

    public PageMarginsFilter(Integer leftMargin, Integer topMargin, Integer rightMargin, Integer bottomMargin) {
        this.leftMargin = leftMargin;
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            this.setMargins(document);
        }
        chain.doFilter(context, document);
    }

    private void setMargins(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        XTextCursor xTextCursor = docText.getText().createTextCursor();
        XPropertySet xTextCursorProps = Lo.qi(XPropertySet.class, xTextCursor);
        String pageStyleName = xTextCursorProps.getPropertyValue("PageStyleName").toString();
        XStyleFamiliesSupplier xSupplier = Lo.qi(XStyleFamiliesSupplier.class, docText);
        XNameAccess xFamilies = Lo.qi(XNameAccess.class, xSupplier.getStyleFamilies());
        XNameContainer xFamily = Lo.qi(XNameContainer.class, xFamilies.getByName("PageStyles"));
        XStyle xStyle = Lo.qi(XStyle.class, xFamily.getByName(pageStyleName));
        Logger.debug("Changing margins using: [left={}, top={}, right={}, bottom={}]", this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin);
        XPropertySet xStyleProps = Lo.qi(XPropertySet.class, xStyle);
        if (this.leftMargin != null) {
            xStyleProps.setPropertyValue("LeftMargin", (Object)(this.leftMargin * 100));
        }
        if (this.topMargin != null) {
            xStyleProps.setPropertyValue("TopMargin", (Object)(this.topMargin * 100));
        }
        if (this.rightMargin != null) {
            xStyleProps.setPropertyValue("RightMargin", (Object)(this.rightMargin * 100));
        }
        if (this.bottomMargin != null) {
            xStyleProps.setPropertyValue("BottomMargin", (Object)(this.bottomMargin * 100));
        }
    }
}

