/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.provider;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.office.metric.TemporaryFileMaker;
import org.aoju.bus.office.provider.AbstractTargetProvider;
import org.aoju.bus.office.provider.TargetDocumentProvider;

public class TargetFromOutputStreamProvider
extends AbstractTargetProvider
implements TargetDocumentProvider {
    private final OutputStream outputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    public TargetFromOutputStreamProvider(OutputStream outputStream, TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        Assert.notNull(outputStream, "The outputStream is null", new Object[0]);
        this.outputStream = outputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    @Override
    public File getFile() {
        return Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
    }

    @Override
    public void onComplete(File tempFile) {
        try {
            FileKit.copyFile(tempFile, this.outputStream);
            if (this.closeStream) {
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            throw new InstrumentException("Could not write file '" + tempFile + "' to stream", ex);
        }
        finally {
            FileKit.delete(tempFile);
        }
    }

    @Override
    public void onFailure(File tempFile, Exception exception) {
        FileKit.delete(tempFile);
    }
}

