/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.Serializable;
import org.aoju.bus.office.support.excel.StyleKit;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Workbook workbook;
    protected CellStyle headCellStyle;
    protected CellStyle cellStyle;
    protected CellStyle cellStyleForNumber;
    protected CellStyle cellStyleForDate;

    public StyleSet(Workbook workbook) {
        this.workbook = workbook;
        this.headCellStyle = StyleKit.createHeadCellStyle(workbook);
        this.cellStyle = StyleKit.createDefaultCellStyle(workbook);
        this.cellStyleForDate = StyleKit.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForDate.setDataFormat((short)22);
        this.cellStyleForNumber = StyleKit.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForNumber.setDataFormat((short)2);
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getCellStyleForNumber() {
        return this.cellStyleForNumber;
    }

    public CellStyle getCellStyleForDate() {
        return this.cellStyleForDate;
    }

    public StyleSet setBorder(BorderStyle borderSize, IndexedColors colorIndex) {
        StyleKit.setBorder(this.headCellStyle, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyle, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyleForNumber, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyleForDate, borderSize, colorIndex);
        return this;
    }

    public StyleSet setAlign(HorizontalAlignment halign, VerticalAlignment valign) {
        StyleKit.setAlign(this.headCellStyle, halign, valign);
        StyleKit.setAlign(this.cellStyle, halign, valign);
        StyleKit.setAlign(this.cellStyleForNumber, halign, valign);
        StyleKit.setAlign(this.cellStyleForDate, halign, valign);
        return this;
    }

    public StyleSet setBackgroundColor(IndexedColors backgroundColor, boolean withHeadCell) {
        if (withHeadCell) {
            StyleKit.setColor(this.headCellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        }
        StyleKit.setColor(this.cellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleKit.setColor(this.cellStyleForNumber, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleKit.setColor(this.cellStyleForDate, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    public StyleSet setFont(short color, short fontSize, String fontName, boolean ignoreHead) {
        Font font = StyleKit.createFont(this.workbook, color, fontSize, fontName);
        return this.setFont(font, ignoreHead);
    }

    public StyleSet setFont(Font font, boolean ignoreHead) {
        if (!ignoreHead) {
            this.headCellStyle.setFont(font);
        }
        this.cellStyle.setFont(font);
        this.cellStyleForNumber.setFont(font);
        this.cellStyleForDate.setFont(font);
        return this;
    }

    public StyleSet setWrapText() {
        this.cellStyle.setWrapText(true);
        this.cellStyleForNumber.setWrapText(true);
        this.cellStyleForDate.setWrapText(true);
        return this;
    }
}

