/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.plugin;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.dialect.Dialect;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public abstract class CountExecutor {
    private static final Field ADDITIONAL_PARAMETERS_FIELD;

    public static Map<String, Object> getAdditionalParameter(BoundSql boundSql) {
        try {
            return (Map)ADDITIONAL_PARAMETERS_FIELD.get(boundSql);
        }
        catch (IllegalAccessException e) {
            throw new PageException("\u83b7\u53d6 BoundSql \u5c5e\u6027\u503c additionalParameters \u5931\u8d25: " + e, e);
        }
    }

    public static MappedStatement getExistedMappedStatement(Configuration configuration, String msId) {
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = configuration.getMappedStatement(msId, false);
        }
        catch (Throwable t) {
            Logger.warn(t.getMessage(), new Object[0]);
        }
        return mappedStatement;
    }

    public static Long executeManualCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, ResultHandler resultHandler) throws SQLException {
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        BoundSql countBoundSql = countMs.getBoundSql(parameter);
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        return ((Number)countResultList.get(0)).longValue();
    }

    public static Long executeAutoCount(Dialect dialect, Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        Map<String, Object> additionalParameters = CountExecutor.getAdditionalParameter(boundSql);
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = dialect.getCountSql(countMs, boundSql, parameter, rowBounds, countKey);
        BoundSql countBoundSql = new BoundSql(countMs.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        return (Long)countResultList.get(0);
    }

    public static <E> List<E> pageQuery(Dialect dialect, Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql, CacheKey cacheKey) throws SQLException {
        if (dialect.beforePage(ms, parameter, rowBounds)) {
            CacheKey pageKey = cacheKey;
            parameter = dialect.processParameterObject(ms, parameter, boundSql, pageKey);
            String pageSql = dialect.getPageSql(ms, boundSql, parameter, rowBounds, pageKey);
            BoundSql pageBoundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
            Map<String, Object> additionalParameters = CountExecutor.getAdditionalParameter(boundSql);
            for (String key : additionalParameters.keySet()) {
                pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
            }
            return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, pageKey, pageBoundSql);
        }
        return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, boundSql);
    }

    static {
        try {
            ADDITIONAL_PARAMETERS_FIELD = BoundSql.class.getDeclaredField("additionalParameters");
            ADDITIONAL_PARAMETERS_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new PageException("\u83b7\u53d6 BoundSql \u5c5e\u6027 additionalParameters \u5931\u8d25: " + e, e);
        }
    }
}

