/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.starter.PlaceBinder;

public class PlaceHandler
implements InvocationHandler {
    private final Annotation delegate;
    private final PlaceBinder binder;

    private PlaceHandler(Annotation delegate, PlaceBinder binder) {
        this.delegate = delegate;
        this.binder = binder;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = method.invoke((Object)this.delegate, args);
        if (!ReflectKit.isEqualsMethod(method) && !ReflectKit.isHashCodeMethod(method) && !ReflectKit.isToStringMethod(method) && this.isAttributeMethod(method)) {
            return this.resolvePlaceHolder(ret);
        }
        return ret;
    }

    private boolean isAttributeMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public Object resolvePlaceHolder(Object origin) {
        if (origin.getClass().isArray()) {
            int length = Array.getLength(origin);
            Object ret = Array.newInstance(origin.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(ret, i, this.resolvePlaceHolder(Array.get(origin, i)));
            }
            return ret;
        }
        return this.doResolvePlaceHolder(origin);
    }

    private Object doResolvePlaceHolder(Object origin) {
        if (origin instanceof String) {
            return this.binder.bind((String)origin);
        }
        return origin;
    }
}

