/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.backend;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.config.PropertiesBasedTraceFilter;
import org.aoju.bus.tracer.config.PropertyChain;
import org.aoju.bus.tracer.config.TraceFilterConfig;

public abstract class AbstractBackend
implements Backend {
    private PropertyChain _lazyPropertyChain;
    private Map<String, TraceFilterConfig> configurationCache = new ConcurrentHashMap<String, TraceFilterConfig>();

    @Override
    public final TraceFilterConfig getConfiguration() {
        return this.getConfiguration(null);
    }

    @Override
    public final TraceFilterConfig getConfiguration(String profileName) {
        String lookupProfile = profileName == null ? "default" : profileName;
        TraceFilterConfig filterConfiguration = this.configurationCache.get(lookupProfile);
        if (filterConfiguration == null) {
            filterConfiguration = new PropertiesBasedTraceFilter(this.getPropertyChain(), lookupProfile);
            this.configurationCache.put(lookupProfile, filterConfiguration);
        }
        return filterConfiguration;
    }

    @Override
    public String getInvocationId() {
        return this.get("TPIC.invocationId");
    }

    @Override
    public String getSessionId() {
        return this.get("TPIC.sessionId");
    }

    private PropertyChain getPropertyChain() {
        if (this._lazyPropertyChain == null) {
            this._lazyPropertyChain = PropertiesBasedTraceFilter.loadPropertyChain();
        }
        return this._lazyPropertyChain;
    }
}

