/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2021 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.core.lang;

/**
 * 标点符号常量
 *
 * @author Kimi Liu
 * @version 6.2.1
 * @since JDK 1.8+
 */
public class Symbol {

    /**
     * 符号: 0
     */
    public static final char C_ZERO = '0';
    public static final String ZERO = Normal.EMPTY + C_ZERO;

    /**
     * 符号: 1
     */
    public static final char C_ONE = '1';
    public static final String ONE = Normal.EMPTY + C_ONE;

    /**
     * 符号: 2
     */
    public static final char C_TWO = '2';
    public static final String TWO = Normal.EMPTY + C_TWO;

    /**
     * 符号: 3
     */
    public static final char C_THREE = '3';
    public static final String THREE = Normal.EMPTY + C_THREE;

    /**
     * 符号: 4
     */
    public static final char C_FOUR = '4';
    public static final String FOUR = Normal.EMPTY + C_FOUR;

    /**
     * 符号: 5
     */
    public static final char C_FIVE = '5';
    public static final String FIVE = Normal.EMPTY + C_FIVE;

    /**
     * 符号: 6
     */
    public static final char C_SIX = '6';
    public static final String SIX = Normal.EMPTY + C_SIX;

    /**
     * 符号: 7
     */
    public static final char C_SEVEN = '7';
    public static final String SEVEN = Normal.EMPTY + C_SEVEN;

    /**
     * 符号: 8
     */
    public static final char C_EIGHT = '8';
    public static final String EIGHT = Normal.EMPTY + C_EIGHT;

    /**
     * 符号: 9
     */
    public static final char C_NINE = '9';
    public static final String NINE = Normal.EMPTY + C_NINE;

    /**
     * 符号: 逗号
     */
    public static final char C_COMMA = ',';
    public static final String COMMA = Normal.EMPTY + C_COMMA;

    /**
     * 符号: 冒号
     */
    public static final char C_COLON = ':';
    public static final String COLON = Normal.EMPTY + C_COLON;

    /**
     * 符号: 波浪符
     */
    public static final char C_TILDE = '~';
    public static final String TILDE = Normal.EMPTY + C_TILDE;

    /**
     * 符号: 空格
     */
    public static final char C_SPACE = ' ';
    public static final String SPACE = Normal.EMPTY + C_SPACE;

    /**
     * 符号: TAB
     */
    public static final char C_TAB = '	';
    public static final String TAB = Normal.EMPTY + C_TAB;

    /**
     * 符号: 小数点
     */
    public static final char C_DOT = '.';
    public static final String DOT = Normal.EMPTY + C_DOT;
    public static final String DOUBLE_DOT = Normal.EMPTY + C_DOT + C_DOT;

    /**
     * 符号: 分号
     */
    public static final char C_SEMICOLON = ';';
    public static final String SEMICOLON = Normal.EMPTY + C_SEMICOLON;

    /**
     * 符号: 下划线
     */
    public static final char C_UNDERLINE = '_';
    public static final String UNDERLINE = Normal.EMPTY + C_UNDERLINE;

    /**
     * 符号: 单引号
     */
    public static final char C_SINGLE_QUOTE = '\'';
    public static final String SINGLE_QUOTE = Normal.EMPTY + C_SINGLE_QUOTE;

    /**
     * 符号: 双引号
     */
    public static final char C_DOUBLE_QUOTES = '"';
    public static final String DOUBLE_QUOTES = Normal.EMPTY + C_DOUBLE_QUOTES;

    /**
     * 符号: 非
     */
    public static final char C_NOT = '!';
    public static final String NOT = Normal.EMPTY + C_NOT;

    /**
     * 符号: 与
     */
    public static final char C_AND = '&';
    public static final String AND = Normal.EMPTY + C_AND;

    /**
     * 符号: 或
     */
    public static final char C_OR = '|';
    public static final String OR = Normal.EMPTY + C_OR;

    /**
     * 符号: @
     */
    public static final char C_AT = '@';
    public static final String AT = Normal.EMPTY + C_AT;

    /**
     * 符号: 星号
     */
    public static final char C_STAR = '*';
    public static final String STAR = Normal.EMPTY + C_STAR;

    /**
     * 符号: 人民币
     */
    public static final char C_CNY = '¥';
    public static final String CNY = Normal.EMPTY + C_CNY;

    /**
     * 符号: 美元
     */
    public static final char C_DOLLAR = '$';
    public static final String DOLLAR = Normal.EMPTY + C_DOLLAR;

    /**
     * 符号: #
     */
    public static final char C_SHAPE = '#';
    public static final String SHAPE = Normal.EMPTY + C_SHAPE;

    /**
     * 符号: 百分比
     */
    public static final char C_PERCENT = '%';
    public static final String PERCENT = Normal.EMPTY + C_PERCENT;

    /**
     * 符号: 幂
     */
    public static final char C_CARET = '^';
    public static final String CARET = Normal.EMPTY + C_CARET;

    /**
     * 符号: 减号
     */
    public static final char C_HYPHEN = '-';
    public static final String HYPHEN = Normal.EMPTY + C_HYPHEN;

    /**
     * 符号: 加号
     */
    public static final char C_PLUS = '+';
    public static final String PLUS = Normal.EMPTY + C_PLUS;

    /**
     * 符号: 等于号
     */
    public static final char C_EQUAL = '=';
    public static final String EQUAL = Normal.EMPTY + C_EQUAL;

    /**
     * 符号: 大于号
     */
    public static final char C_GT = '>';
    public static final String GT = Normal.EMPTY + C_GT;

    /**
     * 符号: 小于号
     */
    public static final char C_LT = '<';
    public static final String LT = Normal.EMPTY + C_LT;

    /**
     * 符号: 大于等于
     */
    public static final String GE = ">=";
    /**
     * 符号: 小于等于
     */
    public static final String LE = "<=";

    /**
     * 符号: 圆括号-左
     */
    public static final char C_PARENTHESE_LEFT = '(';
    public static final String PARENTHESE_LEFT = Normal.EMPTY + C_PARENTHESE_LEFT;

    /**
     * 符号: 圆括号-右
     */
    public static final char C_PARENTHESE_RIGHT = ')';
    public static final String PARENTHESE_RIGHT = Normal.EMPTY + C_PARENTHESE_RIGHT;

    /**
     * 符号: 大括号-左
     */
    public static final char C_BRACE_LEFT = '{';
    public static final String BRACE_LEFT = Normal.EMPTY + C_BRACE_LEFT;

    /**
     * 符号: 大括号-右
     */
    public static final char C_BRACE_RIGHT = '}';
    public static final String BRACE_RIGHT = Normal.EMPTY + C_BRACE_RIGHT;

    /**
     * 符号: 方括号-左
     */
    public static final char C_BRACKET_LEFT = '[';
    public static final String BRACKET_LEFT = Normal.EMPTY + C_BRACKET_LEFT;

    /**
     * 符号: 方括号-右
     */
    public static final char C_BRACKET_RIGHT = ']';
    public static final String BRACKET_RIGHT = Normal.EMPTY + C_BRACKET_RIGHT;

    /**
     * 符号: 问号
     */
    public static final char C_QUESTION_MARK = '?';
    public static final String QUESTION_MARK = Normal.EMPTY + C_QUESTION_MARK;

    /**
     * 符号: /和//
     */
    public static final char C_SLASH = '/';
    public static final String SLASH = Normal.EMPTY + C_SLASH;
    public static final String FORWARDSLASH = SLASH + SLASH;

    /**
     * 符号: 反斜杠
     */
    public static final char C_BACKSLASH = '\\';
    public static final String BACKSLASH = Normal.EMPTY + C_BACKSLASH;

    /**
     * 符号: 回车
     */
    public static final char C_CR = '\r';
    public static final String CR = Normal.EMPTY + C_CR;

    /**
     * 符号: 换行
     */
    public static final char C_LF = '\n';
    public static final String LF = Normal.EMPTY + C_LF;

    /**
     * 符号: 水平制表
     */
    public static final char C_HT = '\t';
    public static final String HT = Normal.EMPTY + C_HT;

    /**
     * 符号: 回车换行
     */
    public static final String CRLF = "\r\n";

    /**
     * 符号: 回车换行
     */
    public static final String NEWLINE = ",\n";

    /**
     * 符号: {}
     */
    public static final String DELIM = "{}";

    /**
     * 符号: []
     */
    public static final String BRACKET = "[]";

    /**
     * 符号: [L
     */
    public static final String NON_PREFIX = "[L";

    /**
     * HTML: 空格
     */
    public static final String HTML_NBSP = "&nbsp;";

    /**
     * HTML: 与
     */
    public static final String HTML_AMP = "&amp;";

    /**
     * HTML: ＂
     */
    public static final String HTML_QUOTE = "&quot;";

    /**
     * HTML: '
     */
    public static final String HTML_APOS = "&apos;";

    /**
     * HTML: 小于号
     */
    public static final String HTML_LT = "&lt;";

    /**
     * HTML: 大于号
     */
    public static final String HTML_GT = "&gt;";

}
