/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.builder.EqualsBuilder;
import org.aoju.bus.core.builder.HashCodeBuilder;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;

public class GeoKit {
    private static final double EARTH_RADIUS = 6378137.0;
    private static final double EE = 0.006693421622965943;

    private static double __rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double distance(Point p1, Point p2) {
        return p1.distance(p2);
    }

    public static Bounds rectangle(Point point, long distance) {
        if (point == null || distance <= 0L) {
            return new Bounds();
        }
        float _delta = 111000.0f;
        if (point.getLatitude() != 0.0 && point.getLongitude() != 0.0) {
            double lng1 = point.longitude - (double)distance / Math.abs(Math.cos(Math.toRadians(point.latitude)) * (double)_delta);
            double lng2 = point.longitude + (double)distance / Math.abs(Math.cos(Math.toRadians(point.latitude)) * (double)_delta);
            double lat1 = point.latitude - (double)((float)distance / _delta);
            double lat2 = point.latitude + (double)((float)distance / _delta);
            return new Bounds(new Point(lng1, lat1), new Point(lng2, lat2));
        }
        double lng1 = point.longitude - (double)((float)distance / _delta);
        double lng2 = point.longitude + (double)((float)distance / _delta);
        double lat1 = point.latitude - (double)((float)distance / _delta);
        double lat2 = point.latitude + (double)((float)distance / _delta);
        return new Bounds(new Point(lng1, lat1), new Point(lng2, lat2));
    }

    public static boolean contains(Polygon polygon, Point point) {
        return GeoKit.contains(polygon, point, false);
    }

    public static boolean contains(Polygon polygon, Point point, boolean on) {
        if (on) {
            return polygon.on(point);
        }
        return polygon.in(point);
    }

    public static int contains(Circle circle, Point point) {
        return circle.contains(point);
    }

    public static class Polygon
    implements Serializable {
        private final List<Point> points = new ArrayList<Point>();

        public Polygon() {
        }

        public Polygon(Point[] points) {
            if (ArrayKit.isNotEmpty(points)) {
                this.points.addAll(Arrays.asList(points));
            }
        }

        public Polygon(Collection<Point> points) {
            if (points != null && !points.isEmpty()) {
                this.points.addAll(points);
            }
        }

        public boolean isEmpty() {
            return this.points.isEmpty();
        }

        public Polygon add(Point point) {
            if (point != null) {
                this.points.add(point);
            }
            return this;
        }

        public Polygon add(double longitude, double latitude) {
            this.points.add(new Point(longitude, latitude));
            return this;
        }

        public List<Point> getPoints() {
            return this.points;
        }

        public boolean in(Point point) {
            int nCross = 0;
            for (int i = 0; i < this.points.size(); ++i) {
                double x;
                Point p1 = this.points.get(i);
                Point p2 = this.points.get((i + 1) % this.points.size());
                if (p1.latitude == p2.latitude || point.latitude < Math.min(p1.latitude, p2.latitude) || point.latitude >= Math.max(p1.latitude, p2.latitude) || !((x = (point.latitude - p1.latitude) * (p2.longitude - p1.longitude) / (p2.latitude - p1.latitude) + p1.longitude) > point.longitude)) continue;
                ++nCross;
            }
            return nCross % 2 == 1;
        }

        public boolean on(Point point) {
            for (int i = 0; i < this.points.size(); ++i) {
                Point p1 = this.points.get(i);
                Point p2 = this.points.get((i + 1) % this.points.size());
                if (point.latitude < Math.min(p1.latitude, p2.latitude) || point.latitude > Math.max(p1.latitude, p2.latitude)) continue;
                if (p1.latitude == p2.latitude) {
                    double minX = Math.min(p1.longitude, p2.longitude);
                    double maxX = Math.max(p1.longitude, p2.longitude);
                    if (point.latitude != p1.latitude || !(point.longitude >= minX) || !(point.longitude <= maxX)) continue;
                    return true;
                }
                double x = (point.latitude - p1.latitude) * (p2.longitude - p1.longitude) / (p2.latitude - p1.latitude) + p1.longitude;
                if (x != point.longitude) continue;
                return true;
            }
            return false;
        }
    }

    public static class Circle
    implements Serializable {
        private Point center;
        private double r;

        public Circle(Point center, double r) {
            this.center = center;
            this.r = r;
        }

        public Point getCenter() {
            return this.center;
        }

        public void setCenter(Point center) {
            this.center = center;
        }

        public double getR() {
            return this.r;
        }

        public void setR(double r) {
            this.r = r;
        }

        public int contains(Point point) {
            double value = Math.hypot(point.longitude - this.center.longitude, point.latitude - this.center.latitude);
            if (value > this.r) {
                return -1;
            }
            if (value < this.r) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Circle circle = (Circle)o;
            return new EqualsBuilder().append(this.r, circle.r).append(this.center, circle.center).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.center).append(this.r).toHashCode();
        }
    }

    public static class Bounds
    implements Serializable {
        private Point southWest;
        private Point northEast;

        public Bounds() {
        }

        public Bounds(Bounds first, Bounds other) {
            if (first == null || first.isEmpty() || other == null || other.isEmpty()) {
                throw new InstrumentException("bounds");
            }
            this.southWest = new Point(Math.min(first.southWest.getLongitude(), other.southWest.getLongitude()), Math.min(first.southWest.getLatitude(), other.southWest.getLatitude()));
            this.northEast = new Point(Math.max(first.northEast.getLongitude(), other.northEast.getLongitude()), Math.max(first.northEast.getLatitude(), other.northEast.getLatitude()));
        }

        public Bounds(Point southWest, Point northEast) {
            this.southWest = southWest;
            this.northEast = northEast;
        }

        public Point getSouthWest() {
            return this.southWest;
        }

        public void setSouthWest(Point southWest) {
            this.southWest = southWest;
        }

        public Point getNorthEast() {
            return this.northEast;
        }

        public void setNorthEast(Point northEast) {
            this.northEast = northEast;
        }

        public Point getCenter() {
            return new Point((this.southWest.longitude + this.northEast.longitude) / 2.0, (this.southWest.latitude + this.northEast.latitude) / 2.0);
        }

        public boolean isEmpty() {
            return this.southWest == null || this.northEast == null;
        }

        public boolean contains(Point point) {
            return !this.isEmpty() && point.longitude >= this.southWest.longitude && point.longitude <= this.northEast.longitude && point.latitude >= this.southWest.latitude && point.latitude <= this.northEast.latitude;
        }

        public boolean contains(Bounds bounds) {
            return this.contains(bounds.southWest) && this.contains(bounds.northEast);
        }

        public Bounds intersects(Bounds bounds) {
            if (bounds != null && !bounds.isEmpty() && !this.isEmpty()) {
                double _y2;
                Bounds _merged = new Bounds(this, bounds);
                double _x1 = this.southWest.longitude == _merged.southWest.longitude ? bounds.southWest.longitude : this.southWest.longitude;
                double _y1 = this.southWest.latitude == _merged.southWest.latitude ? bounds.southWest.latitude : this.southWest.latitude;
                double _x2 = this.northEast.longitude == _merged.northEast.longitude ? bounds.northEast.longitude : this.northEast.longitude;
                double d = _y2 = this.northEast.latitude == _merged.northEast.latitude ? bounds.northEast.latitude : this.northEast.latitude;
                if (_x1 < _x2 && _y1 < _y2) {
                    return new Bounds(new Point(_x1, _y1), new Point(_x2, _y2));
                }
            }
            return new Bounds();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            return new EqualsBuilder().append(this.southWest, bounds.southWest).append(this.northEast, bounds.northEast).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.southWest).append(this.northEast).toHashCode();
        }
    }

    public static class Point
    implements Serializable {
        private double longitude;
        private double latitude;
        private PointType type;

        public Point(double longitude, double latitude, PointType type) {
            this.longitude = longitude;
            this.latitude = latitude;
            this.type = type == null ? PointType.WGS84 : type;
        }

        public Point(double longitude, double latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
            this.type = PointType.WGS84;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public PointType getType() {
            return this.type;
        }

        public void setType(PointType type) {
            this.type = type;
        }

        public Point2D.Double toPoint2D() {
            return new Point2D.Double(this.longitude, this.latitude);
        }

        public Point toGcj02() {
            Point _point;
            switch (this.type) {
                case BD09: {
                    _point = this.__bd09ToGcj02();
                    break;
                }
                case GCJ02: {
                    _point = new Point(this.longitude, this.latitude, PointType.GCJ02);
                    break;
                }
                default: {
                    _point = this.__transform();
                }
            }
            return _point;
        }

        public Point toWgs84() {
            Point _point;
            switch (this.type) {
                case BD09: {
                    _point = this.__bd09ToWgs84();
                    break;
                }
                case GCJ02: {
                    _point = this.__gcj02ToWgs84();
                    break;
                }
                default: {
                    _point = new Point(this.longitude, this.latitude);
                }
            }
            return _point;
        }

        public Point toBd09() {
            Point _point;
            switch (this.type) {
                case BD09: {
                    _point = new Point(this.longitude, this.latitude, PointType.BD09);
                    break;
                }
                case GCJ02: {
                    _point = this.__gcj02ToBd09();
                    break;
                }
                default: {
                    _point = this.__wgs84ToBd09();
                }
            }
            return _point;
        }

        public Point retain6() {
            return new Point(Double.valueOf(String.format("%.6f", this.longitude)), Double.valueOf(String.format("%.6f", this.latitude)), this.type);
        }

        public boolean notInChina() {
            if (this.longitude < 72.004 || this.longitude > 137.8347) {
                return true;
            }
            return this.latitude < 0.8293 || this.latitude > 55.8271;
        }

        private double __transformLat() {
            double x = this.longitude - 105.0;
            double y = this.latitude - 35.0;
            double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
            ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
            ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
            return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
        }

        private double __transformLon() {
            double x = this.longitude - 105.0;
            double y = this.latitude - 35.0;
            double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
            ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
            ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
            return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
        }

        private Point __transform() {
            if (this.notInChina()) {
                return new Point(this.longitude, this.latitude);
            }
            double dLat = this.__transformLat();
            double dLon = this.__transformLon();
            double radLat = GeoKit.__rad(this.latitude);
            double magic = Math.sin(radLat);
            magic = 1.0 - 0.006693421622965943 * magic * magic;
            double sqrtMagic = Math.sqrt(magic);
            dLat = dLat * 180.0 / (6335445.439889961 / (magic * sqrtMagic) * Math.PI);
            dLon = dLon * 180.0 / (6378137.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
            double mgLat = this.latitude + dLat;
            double mgLon = this.longitude + dLon;
            return new Point(mgLon, mgLat, PointType.GCJ02);
        }

        private Point __gcj02ToWgs84() {
            Point _point = this.__transform();
            return new Point(this.longitude * 2.0 - _point.longitude, this.latitude * 2.0 - _point.latitude);
        }

        private Point __gcj02ToBd09() {
            double z = Math.sqrt(this.longitude * this.longitude + this.latitude * this.latitude) + 2.0E-5 * Math.sin(this.latitude * Math.PI);
            double theta = Math.atan2(this.latitude, this.longitude) + 3.0E-6 * Math.cos(this.longitude * Math.PI);
            return new Point(z * Math.cos(theta) + 0.0065, z * Math.sin(theta) + 0.006, PointType.BD09);
        }

        private Point __bd09ToGcj02() {
            double x = this.longitude - 0.0065;
            double y = this.latitude - 0.006;
            double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * Math.PI);
            double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * Math.PI);
            return new Point(z * Math.cos(theta), z * Math.sin(theta), PointType.GCJ02);
        }

        private Point __wgs84ToBd09() {
            Point _point = this.__transform();
            return _point.toBd09();
        }

        private Point __bd09ToWgs84() {
            Point _point = this.__bd09ToGcj02();
            return _point.toWgs84();
        }

        public double distance(Point point) {
            double _lat1 = GeoKit.__rad(this.latitude);
            double _lat2 = GeoKit.__rad(point.latitude);
            double _diff = GeoKit.__rad(this.longitude) - GeoKit.__rad(point.longitude);
            return Math.round(2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((_lat1 - _lat2) / 2.0), 2.0) + Math.cos(_lat1) * Math.cos(_lat2) * Math.pow(Math.sin(_diff / 2.0), 2.0))) * 6378137.0 * 10000.0) / 10000L;
        }

        public boolean isValidCoordinate() {
            if (0.0 > this.longitude || 180.0 < this.longitude) {
                return false;
            }
            return !(0.0 > this.latitude) && !(90.0 < this.latitude);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            return new EqualsBuilder().append(this.longitude, point.longitude).append(this.latitude, point.latitude).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.longitude).append(this.latitude).toHashCode();
        }
    }

    public static enum PointType {
        WGS84,
        GCJ02,
        BD09;

    }
}

