/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.software.LinuxOSFileStore;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class LinuxFileSystem
extends AbstractFileSystem {
    public static final String OSHI_LINUX_FS_PATH_EXCLUDES = "health.os.linux.filesystem.path.excludes";
    public static final String OSHI_LINUX_FS_PATH_INCLUDES = "health.os.linux.filesystem.path.includes";
    public static final String OSHI_LINUX_FS_VOLUME_EXCLUDES = "health.os.linux.filesystem.volume.excludes";
    public static final String OSHI_LINUX_FS_VOLUME_INCLUDES = "health.os.linux.filesystem.volume.includes";
    private static final List<PathMatcher> FS_PATH_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.linux.filesystem.path.excludes");
    private static final List<PathMatcher> FS_PATH_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.linux.filesystem.path.includes");
    private static final List<PathMatcher> FS_VOLUME_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.linux.filesystem.volume.excludes");
    private static final List<PathMatcher> FS_VOLUME_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.linux.filesystem.volume.includes");
    private static final String UNICODE_SPACE = "\\\\040";
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/run", "/sys", "/proc", ProcPath.PROC);

    static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap) {
        return LinuxFileSystem.getFileStoreMatching(nameToMatch, uuidMap, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        Map<String, String> labelMap = LinuxFileSystem.queryLabelMap();
        List<String> mounts = FileKit.readLines(ProcPath.MOUNTS);
        for (String mount : mounts) {
            String uuid;
            String volume;
            String[] split = mount.split(" ");
            if (split.length < 6) continue;
            String name = volume = split[0].replace(UNICODE_SPACE, " ");
            String path = split[1].replace(UNICODE_SPACE, " ");
            if (path.equals("/")) {
                volume = "/";
            }
            String type = split[2];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || !path.equals("/") && (PSEUDO_FS_TYPES.contains(type) || Builder.isFileStoreExcluded(path, volume, FS_PATH_INCLUDES, FS_PATH_EXCLUDES, FS_VOLUME_INCLUDES, FS_VOLUME_EXCLUDES))) continue;
            String options = split[3];
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            String string = uuid = uuidMap != null ? uuidMap.getOrDefault(split[0], "") : "";
            String description = volume.startsWith("/dev") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            String logicalVolume = "";
            String volumeMapperDirectory = "/dev/mapper/";
            Path link = Paths.get(volume, new String[0]);
            if (link.toFile().exists() && Files.isSymbolicLink(link)) {
                try {
                    Path slink = Files.readSymbolicLink(link);
                    Path full = Paths.get(volumeMapperDirectory + slink.toString(), new String[0]);
                    if (full.toFile().exists()) {
                        logicalVolume = full.normalize().toString();
                    }
                }
                catch (IOException e) {
                    Logger.warn("Couldn't access symbolic path  {}. {}", link, e.getMessage());
                }
            }
            long totalInodes = 0L;
            long freeInodes = 0L;
            long totalSpace = 0L;
            long usableSpace = 0L;
            long freeSpace = 0L;
            try {
                LibC.Statvfs vfsStat = new LibC.Statvfs();
                if (0 == LibC.INSTANCE.statvfs(path, vfsStat)) {
                    totalInodes = vfsStat.f_files.longValue();
                    freeInodes = vfsStat.f_ffree.longValue();
                    totalSpace = vfsStat.f_blocks.longValue() * vfsStat.f_frsize.longValue();
                    usableSpace = vfsStat.f_bavail.longValue() * vfsStat.f_frsize.longValue();
                    freeSpace = vfsStat.f_bfree.longValue() * vfsStat.f_frsize.longValue();
                } else {
                    Logger.warn("Failed to get information to use statvfs. path: {}, Error code: {}", path, Native.getLastError());
                }
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                Logger.error("Failed to get file counts from statvfs. {}", e.getMessage());
            }
            if (totalSpace == 0L) {
                File tmpFile = new File(path);
                totalSpace = tmpFile.getTotalSpace();
                usableSpace = tmpFile.getUsableSpace();
                freeSpace = tmpFile.getFreeSpace();
            }
            fsList.add(new LinuxOSFileStore(name, volume, labelMap.getOrDefault(path, name), path, options, uuid, logicalVolume, description, type, freeSpace, usableSpace, totalSpace, freeInodes, totalInodes));
        }
        return fsList;
    }

    private static Map<String, String> queryLabelMap() {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (String line : Executor.runNative("lsblk -o mountpoint,label")) {
            String[] split = RegEx.SPACES.split(line, 2);
            if (split.length != 2) continue;
            labelMap.put(split[0], split[1]);
        }
        return labelMap;
    }

    private static long getFileDescriptors(int index) {
        String filename = ProcPath.SYS_FS_FILE_NR;
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("Index must be between 0 and 2.");
        }
        List<String> osDescriptors = FileKit.readLines(filename);
        if (!osDescriptors.isEmpty()) {
            String[] splittedLine = osDescriptors.get(0).split("\\D+");
            return Builder.parseLongOrDefault(splittedLine[index], 0L);
        }
        return 0L;
    }

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        HashMap<String, String> volumeDeviceMap = new HashMap<String, String>();
        File devMapper = new File("/dev/mapper");
        File[] volumes = devMapper.listFiles();
        if (volumes != null) {
            for (File volume : volumes) {
                try {
                    volumeDeviceMap.put(volume.getCanonicalPath(), volume.getAbsolutePath());
                }
                catch (IOException e) {
                    Logger.error("Couldn't get canonical path for {}. {}", volume.getName(), e.getMessage());
                }
            }
        }
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        File uuidDir = new File("/dev/disk/by-uuid");
        File[] uuids = uuidDir.listFiles();
        if (uuids != null) {
            for (File uuid : uuids) {
                try {
                    String canonicalPath = uuid.getCanonicalPath();
                    uuidMap.put(canonicalPath, uuid.getName().toLowerCase());
                    if (!volumeDeviceMap.containsKey(canonicalPath)) continue;
                    uuidMap.put((String)volumeDeviceMap.get(canonicalPath), uuid.getName().toLowerCase());
                }
                catch (IOException e) {
                    Logger.error("Couldn't get canonical path for {}. {}", uuid.getName(), e.getMessage());
                }
            }
        }
        return LinuxFileSystem.getFileStoreMatching(null, uuidMap, localOnly);
    }

    @Override
    public long getOpenFileDescriptors() {
        return LinuxFileSystem.getFileDescriptors(0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return LinuxFileSystem.getFileDescriptors(2);
    }
}

