/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import java.util.List;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOSThread;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.unix.aix.software.AixOSProcess;

public class AixOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    public AixOSThread(int pid, String[] split) {
        super(pid);
        this.updateAttributes(split);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean updateAttributes() {
        List<String> threadListInfoPs = Executor.runNative("ps -m -o THREAD -p " + this.getOwningProcessId());
        if (threadListInfoPs.size() > 2) {
            threadListInfoPs.remove(0);
            threadListInfoPs.remove(0);
            for (String threadInfo : threadListInfoPs) {
                String[] threadInfoSplit = RegEx.SPACES.split(threadInfo.trim());
                if (threadInfoSplit.length != 13 || !threadInfoSplit[3].equals(String.valueOf(this.getThreadId()))) continue;
                String[] split = new String[]{threadInfoSplit[3], threadInfoSplit[4], threadInfoSplit[6]};
                this.updateAttributes(split);
            }
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(String[] split) {
        this.threadId = Builder.parseIntOrDefault(split[0], 0);
        this.state = AixOSProcess.getStateFromOutput(split[1].charAt(0));
        this.priority = Builder.parseIntOrDefault(split[2], 0);
        return true;
    }
}

