/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.ImageConversion;
import org.aoju.bus.image.nimble.opencv.JPEGLSImageWriteParam;
import org.aoju.bus.image.nimble.opencv.NativeImageReader;
import org.aoju.bus.logger.Logger;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.imgcodecs.Imgcodecs;

public class NativeJLSImageWriter
extends ImageWriter {
    NativeJLSImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGLSImageWriteParam(this.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("input cannot be null");
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("input is not an ImageInputStream!");
        }
        ImageOutputStream stream = (ImageOutputStream)this.output;
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        if (!(stream instanceof BytesWithImageDescriptor)) {
            throw new IllegalArgumentException("stream does not implement BytesWithImageImageDescriptor!");
        }
        ImageDescriptor desc = ((BytesWithImageDescriptor)((Object)stream)).getImageDescriptor();
        RenderedImage renderedImage = image.getRenderedImage();
        Mat buf = null;
        MatOfInt dicomParams = null;
        try {
            ImageCV mat = null;
            try {
                int dcmFlags;
                mat = ImageConversion.toMat(renderedImage, param.getSourceRegion(), false);
                int jpeglsNLE = param instanceof JPEGLSImageWriteParam ? ((JPEGLSImageWriteParam)param).getNearLossless() : 0;
                int bitCompressed = desc.getBitsCompressed();
                int cvType = mat.type();
                int channels = CvType.channels((int)cvType);
                boolean signed = desc.isSigned();
                int n = dcmFlags = signed ? 1 : 0;
                if (signed) {
                    Logger.warn("Force compression to JPEG-LS lossless as lossy is not adapted to signed data.", new Object[0]);
                    jpeglsNLE = 0;
                    bitCompressed = 16;
                }
                int[] params = new int[15];
                params[0] = -1;
                params[1] = dcmFlags;
                params[2] = mat.width();
                params[3] = mat.height();
                params[4] = 2;
                params[5] = channels;
                params[6] = bitCompressed;
                params[7] = 2;
                params[11] = jpeglsNLE;
                dicomParams = new MatOfInt(params);
                buf = Imgcodecs.dicomJpgWrite((Mat)mat, (MatOfInt)dicomParams, (String)"");
                if (buf.empty()) {
                    throw new IIOException("Native JPEG-LS encoding error: null image");
                }
            }
            finally {
                if (mat != null) {
                    mat.release();
                }
            }
            byte[] bSrcData = new byte[buf.width() * buf.height() * (int)buf.elemSize()];
            buf.get(0, 0, bSrcData);
            stream.write(bSrcData);
        }
        catch (Throwable t) {
            try {
                throw new IIOException("Native JPEG-LS encoding error", t);
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(dicomParams);
                NativeImageReader.closeMat(buf);
                throw throwable;
            }
        }
        NativeImageReader.closeMat((Mat)dicomParams);
        NativeImageReader.closeMat(buf);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }
}

