/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.UUID;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProperty;

public class AliyunSmsProvider
extends AliyunProvider<AliyunSmsProperty, Context> {
    private static final String ALIYUN_SMS_API = "dysmsapi.aliyuncs.com";

    public AliyunSmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(AliyunSmsProperty entity) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SignatureMethod", "HMAC-SHA1");
        params.put("SignatureNonce", UUID.randomUUID().toString());
        params.put("AccessKeyId", this.properties.getAppKey());
        params.put("SignatureVersion", "1.0");
        params.put("Timestamp", df.format(new Date()));
        params.put("Format", "JSON");
        params.put("Action", "SendSms");
        params.put("Version", "2017-05-25");
        params.put("RegionId", "cn-hangzhou");
        params.put("PhoneNumbers", entity.getReceive());
        params.put("SignName", this.properties.getSignName());
        params.put("TemplateParam", entity.getTemplateParam());
        params.put("TemplateCode", entity.getTempCode());
        params.put("Signature", this.getSign(params));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String str : params.keySet()) {
            map.put(this.specialUrlEncode(str), this.specialUrlEncode((String)params.get(str)));
        }
        return this.checkResponse(Httpx.get("https://dysmsapi.aliyuncs.com", map));
    }
}

