/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.support.excel.sax.CellDataType;
import org.aoju.bus.office.support.excel.sax.Excel03SaxReader;
import org.aoju.bus.office.support.excel.sax.Excel07SaxReader;
import org.aoju.bus.office.support.excel.sax.ExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxKit {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        return isXlsx ? new Excel07SaxReader(rowHandler) : new Excel03SaxReader(rowHandler);
    }

    public static Object getDataValue(CellDataType cellDataType, String value, SharedStringsTable sharedStringsTable, String numFmtString) {
        Object result;
        if (null == value) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        switch (cellDataType) {
            case BOOL: {
                result = value.charAt(0) != '0';
                break;
            }
            case ERROR: {
                result = StringKit.format("\\\"ERROR: {} ", value);
                break;
            }
            case FORMULA: {
                result = StringKit.format("\"{}\"", value);
                break;
            }
            case INLINESTR: {
                result = new XSSFRichTextString(value).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value);
                    result = sharedStringsTable.getItemAt(index).getString();
                }
                catch (NumberFormatException e) {
                    result = value;
                }
                break;
            }
            case NUMBER: {
                try {
                    result = ExcelSaxKit.getNumberValue(value, numFmtString);
                }
                catch (NumberFormatException e) {
                    result = value;
                }
                break;
            }
            case DATE: {
                try {
                    result = ExcelSaxKit.getDateValue(value);
                }
                catch (Exception e) {
                    result = value;
                }
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = StringKit.nullToDefault(preRef, "@").replaceAll("\\d+", "");
        String xfd = StringKit.nullToDefault(ref, "@").replaceAll("\\d+", "");
        preXfd = StringKit.fillBefore(preXfd, '@', 3);
        xfd = StringKit.fillBefore(xfd, '@', 3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws InstrumentException {
        try {
            XMLReader xmlReader = XMLHelper.newXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InstrumentException(e);
        }
    }

    public static DateTime getDateValue(String value) {
        return ExcelSaxKit.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return DateKit.date(DateUtil.getJavaDate((double)value, (boolean)false));
    }

    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value, FormatTrackingHSSFListener formatListener) {
        if (Builder.isDateFormat(formatListener.getFormatIndex(cell), formatListener.getFormatString(cell))) {
            return ExcelSaxKit.getDateValue(value);
        }
        return ExcelSaxKit.getNumberValue(value, formatListener.getFormatString(cell));
    }

    private static Number getNumberValue(String value, String numFmtString) {
        if (StringKit.isBlank(value)) {
            return null;
        }
        return ExcelSaxKit.getNumberValue(Double.parseDouble(value), numFmtString);
    }

    private static Number getNumberValue(double numValue, String numFmtString) {
        if (null != numFmtString && !StringKit.contains((CharSequence)numFmtString, ".")) {
            return (long)numValue;
        }
        return numValue;
    }
}

