/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetSaxReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<String, String> ID_RID_MAP = new HashMap<String, String>();
    private final Map<String, String> NAME_RID_MAP = new HashMap<String, String>();

    public SheetSaxReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxKit.readFrom(workbookData, this);
        }
        catch (IOException | InvalidFormatException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(workbookData);
        }
        return this;
    }

    public String getRidBySheetId(String sheetId) {
        return this.ID_RID_MAP.get(sheetId);
    }

    public String getRidByName(String sheetName) {
        return this.NAME_RID_MAP.get(sheetName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            String sheetIdStr;
            String ridStr = attributes.getValue(RID_ATTR);
            if (StringKit.isEmpty(ridStr)) {
                return;
            }
            String rid = StringKit.removePrefixIgnoreCase(ridStr, "rId");
            String name = attributes.getValue(NAME_ATTR);
            if (StringKit.isNotEmpty(name)) {
                this.NAME_RID_MAP.put(name, rid);
            }
            if (StringKit.isNotEmpty(sheetIdStr = attributes.getValue(SHEET_ID_ATTR))) {
                this.ID_RID_MAP.put(sheetIdStr, rid);
            }
        }
    }
}

