/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.nio.channels.AsynchronousChannelGroup;
import org.aoju.bus.socket.AioQuickClient;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class ReconnectPlugin<T>
extends AbstractPlugin<T> {
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    private final AioQuickClient<T> client;
    private boolean shutdown = false;

    public ReconnectPlugin(AioQuickClient<T> client) {
        this(client, null);
    }

    public ReconnectPlugin(AioQuickClient<T> client, AsynchronousChannelGroup asynchronousChannelGroup) {
        this.client = client;
        this.asynchronousChannelGroup = asynchronousChannelGroup;
    }

    @Override
    public void stateEvent(SocketStatus socketStatus, AioSession session, Throwable throwable) {
        if (socketStatus != SocketStatus.SESSION_CLOSED || this.shutdown) {
            return;
        }
        try {
            if (this.asynchronousChannelGroup == null) {
                this.client.start();
            } else {
                this.client.start(this.asynchronousChannelGroup);
            }
        }
        catch (Exception e) {
            this.shutdown = true;
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

