/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberChinese {
    private static final NameValue[] NAME_VALUE = new NameValue[]{new NameValue("\u5341", 10, false), new NameValue("\u767e", 100, false), new NameValue("\u5343", 1000, false), new NameValue("\u4e07", 10000, true), new NameValue("\u4ebf", 100000000, true)};

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChinese.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        String[] numArray;
        String[] stringArray = numArray = isUseTraditional ? Normal.TRADITIONAL_DIGITS : Normal.SIMPLE_DIGITS;
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        StringBuilder val = new StringBuilder();
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumberChinese.toChinese(parts[i2], isUseTraditional);
            if (i2 % 2 == 0) {
                beforeWanIsZero = StringKit.isEmpty(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    val.insert(0, "\u4ebf");
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    val.insert(0, "\u96f6");
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        val.insert(0, "\u96f6");
                    }
                    if (parts[i2] > 0) {
                        val.insert(0, "\u4e07");
                    }
                }
            }
            val.insert(0, partChinese);
        }
        if ("".equals(val.toString())) {
            val = new StringBuilder(numArray[0]);
        }
        if (negative) {
            val.insert(0, "\u8d1f");
        }
        if (numFen != 0 || numJiao != 0) {
            if (numFen == 0) {
                val.append(isMoneyMode ? "\u5143" : "\u70b9").append(numArray[numJiao]).append(isMoneyMode ? "\u89d2" : "");
            } else if (numJiao == 0) {
                val.append(isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6").append(numArray[numFen]).append(isMoneyMode ? "\u5206" : "");
            } else {
                val.append(isMoneyMode ? "\u5143" : "\u70b9").append(numArray[numJiao]).append(isMoneyMode ? "\u89d2" : "").append(numArray[numFen]).append(isMoneyMode ? "\u5206" : "");
            }
        } else if (isMoneyMode) {
            val.append("\u5143\u6574");
        }
        return val.toString();
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? Normal.TRADITIONAL_DIGITS : Normal.SIMPLE_DIGITS;
        String[] units = isUseTraditional ? Normal.TRADITIONAL_UNITS : Normal.SIMPLE_UNITS;
        int temp = amountPart;
        String chineseStr = "";
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0 && temp != 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
            } else {
                chineseStr = numArray[digit] + units[i] + chineseStr;
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr;
    }

    public static String toChinese(char c, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? Normal.TRADITIONAL_DIGITS : Normal.SIMPLE_DIGITS;
        int index = c - 48;
        if (index < 0 || index >= numArray.length) {
            return String.valueOf(c);
        }
        return numArray[index];
    }

    public static int chineseToNumber(String chinese) {
        int pos = 0;
        int rtn = 0;
        int section = 0;
        int number = 0;
        boolean secUnit = false;
        int length = chinese.length();
        while (pos < length) {
            int num = ArrayKit.indexOf(Normal.SIMPLE_DIGITS, chinese.substring(pos, pos + 1));
            if (num >= 0) {
                number = num;
                if (++pos < length) continue;
                rtn += (section += number);
                break;
            }
            int unit = 1;
            int tmp = NumberChinese.chineseToUnit(chinese.substring(pos, pos + 1));
            if (tmp != -1) {
                unit = NAME_VALUE[tmp].value;
                secUnit = NAME_VALUE[tmp].secUnit;
            }
            if (secUnit) {
                section = (section + number) * unit;
                rtn += section;
                section = 0;
            } else {
                section += number * unit;
            }
            number = 0;
            if (++pos < chinese.length()) continue;
            rtn += section;
            break;
        }
        return rtn;
    }

    private static int chineseToUnit(String chinese) {
        for (int i = 0; i < NAME_VALUE.length; ++i) {
            if (!NAME_VALUE[i].name.equals(chinese)) continue;
            return i;
        }
        return -1;
    }

    private static class NameValue {
        private final String name;
        private final int value;
        private final boolean secUnit;

        public NameValue(String name, int value, boolean secUnit) {
            this.name = name;
            this.value = value;
            this.secUnit = secUnit;
        }
    }
}

