/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.text.Builders;
import org.aoju.bus.core.text.Lookups;
import org.aoju.bus.core.text.Matchers;
import org.aoju.bus.core.toolkit.StringKit;

public class Replacers {
    public static final Matchers DEFAULT_PREFIX = Matchers.stringMatcher("${");
    public static final Matchers DEFAULT_SUFFIX = Matchers.stringMatcher("}");
    public static final Matchers DEFAULT_VALUE_DELIMITER = Matchers.stringMatcher(":-");
    private char escapeChar;
    private Matchers prefixMatcher;
    private Matchers suffixMatcher;
    private Matchers valueDelimiterMatcher;
    private Lookups<?> variableResolver;
    private boolean enableSubstitutionInVariables;
    private boolean preserveEscapes = false;

    public Replacers() {
        this(null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> Replacers(Map<String, V> valueMap) {
        this(Lookups.mapLookup(valueMap), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> Replacers(Map<String, V> valueMap, String prefix, String suffix) {
        this(Lookups.mapLookup(valueMap), prefix, suffix, '$');
    }

    public <V> Replacers(Map<String, V> valueMap, String prefix, String suffix, char escape) {
        this(Lookups.mapLookup(valueMap), prefix, suffix, escape);
    }

    public <V> Replacers(Map<String, V> valueMap, String prefix, String suffix, char escape, String delimiter) {
        this(Lookups.mapLookup(valueMap), prefix, suffix, escape, delimiter);
    }

    public Replacers(Lookups<?> resolver) {
        this(resolver, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public Replacers(Lookups<?> resolver, String prefix, String suffix, char escape) {
        this.setVariableResolver(resolver);
        this.setVariablePrefix(prefix);
        this.setVariableSuffix(suffix);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(DEFAULT_VALUE_DELIMITER);
    }

    public Replacers(Lookups<?> resolver, String prefix, String suffix, char escape, String delimiter) {
        this.setVariableResolver(resolver);
        this.setVariablePrefix(prefix);
        this.setVariableSuffix(suffix);
        this.setEscapeChar(escape);
        this.setValueDelimiter(delimiter);
    }

    public Replacers(Lookups<?> resolver, Matchers prefixMatcher, Matchers suffixMatcher, char escape) {
        this(resolver, prefixMatcher, suffixMatcher, escape, DEFAULT_VALUE_DELIMITER);
    }

    public Replacers(Lookups<?> resolver, Matchers prefixMatcher, Matchers suffixMatcher, char escape, Matchers delimiter) {
        this.setVariableResolver(resolver);
        this.setVariablePrefixMatcher(prefixMatcher);
        this.setVariableSuffixMatcher(suffixMatcher);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(delimiter);
    }

    public static <V> String replace(Object source, Map<String, V> valueMap) {
        return new Replacers(valueMap).replace(source);
    }

    public static <V> String replace(Object source, Map<String, V> valueMap, String prefix, String suffix) {
        return new Replacers(valueMap, prefix, suffix).replace(source);
    }

    public static String replace(Object source, Properties value) {
        if (null == value) {
            return source.toString();
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Enumeration<?> propNames = value.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = value.getProperty(propName);
            valueMap.put(propName, propValue);
        }
        return Replacers.replace(source, valueMap);
    }

    public static String replaceSystemProperties(Object source) {
        return new Replacers(Lookups.systemPropertiesLookup()).replace(source);
    }

    public String replace(String source) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(source);
        if (!this.substitute(buf, 0, source.length())) {
            return source;
        }
        return buf.toString();
    }

    public String replace(String source, int offset, int length) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        if (!this.substitute(buf, 0, length)) {
            return source.substring(offset, offset + length);
        }
        return buf.toString();
    }

    public String replace(char[] source) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(source.length).append(source);
        this.substitute(buf, 0, source.length);
        return buf.toString();
    }

    public String replace(char[] source, int offset, int length) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        this.substitute(buf, 0, length);
        return buf.toString();
    }

    public String replace(StringBuffer source) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(source.length()).append(source);
        this.substitute(buf, 0, buf.length());
        return buf.toString();
    }

    public String replace(StringBuffer source, int offset, int length) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        this.substitute(buf, 0, length);
        return buf.toString();
    }

    public String replace(CharSequence source) {
        if (null == source) {
            return null;
        }
        return this.replace(source, 0, source.length());
    }

    public String replace(CharSequence source, int offset, int length) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        this.substitute(buf, 0, length);
        return buf.toString();
    }

    public String replace(Builders source) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(source.length()).append(source);
        this.substitute(buf, 0, buf.length());
        return buf.toString();
    }

    public String replace(Builders source, int offset, int length) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        this.substitute(buf, 0, length);
        return buf.toString();
    }

    public String replace(Object source) {
        if (null == source) {
            return null;
        }
        Builders buf = new Builders().append(source);
        this.substitute(buf, 0, buf.length());
        return buf.toString();
    }

    public boolean replaceIn(StringBuffer source) {
        if (null == source) {
            return false;
        }
        return this.replaceIn(source, 0, source.length());
    }

    public boolean replaceIn(StringBuffer source, int offset, int length) {
        if (null == source) {
            return false;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        if (!this.substitute(buf, 0, length)) {
            return false;
        }
        source.replace(offset, offset + length, buf.toString());
        return true;
    }

    public boolean replaceIn(StringBuilder source) {
        if (null == source) {
            return false;
        }
        return this.replaceIn(source, 0, source.length());
    }

    public boolean replaceIn(StringBuilder source, int offset, int length) {
        if (null == source) {
            return false;
        }
        Builders buf = new Builders(length).append(source, offset, length);
        if (!this.substitute(buf, 0, length)) {
            return false;
        }
        source.replace(offset, offset + length, buf.toString());
        return true;
    }

    public boolean replaceIn(Builders source) {
        if (null == source) {
            return false;
        }
        return this.substitute(source, 0, source.length());
    }

    public boolean replaceIn(Builders source, int offset, int length) {
        if (null == source) {
            return false;
        }
        return this.substitute(source, offset, length);
    }

    protected boolean substitute(Builders buffer, int offset, int length) {
        return this.substitute(buffer, offset, length, null) > 0;
    }

    private int substitute(Builders buffer, int offset, int length, List<String> priorVariables) {
        Matchers pfxMatcher = this.getVariablePrefixMatcher();
        Matchers suffMatcher = this.getVariableSuffixMatcher();
        char escape = this.getEscapeChar();
        Matchers valueDelimMatcher = this.getValueDelimiterMatcher();
        boolean substitutionInVariablesEnabled = this.isEnableSubstitutionInVariables();
        boolean top = null == priorVariables;
        boolean altered = false;
        int lengthChange = 0;
        char[] chars = buffer.buffer;
        int bufEnd = offset + length;
        int pos = offset;
        block0: while (pos < bufEnd) {
            int startMatchLen = pfxMatcher.isMatch(chars, pos, offset, bufEnd);
            if (startMatchLen == 0) {
                ++pos;
                continue;
            }
            if (pos > offset && chars[pos - 1] == escape) {
                if (this.preserveEscapes) {
                    ++pos;
                    continue;
                }
                buffer.deleteCharAt(pos - 1);
                chars = buffer.buffer;
                --lengthChange;
                altered = true;
                --bufEnd;
                continue;
            }
            int startPos = pos;
            pos += startMatchLen;
            int endMatchLen = 0;
            int nestedVarCount = 0;
            while (pos < bufEnd) {
                if (substitutionInVariablesEnabled && (endMatchLen = pfxMatcher.isMatch(chars, pos, offset, bufEnd)) != 0) {
                    ++nestedVarCount;
                    pos += endMatchLen;
                    continue;
                }
                endMatchLen = suffMatcher.isMatch(chars, pos, offset, bufEnd);
                if (endMatchLen == 0) {
                    ++pos;
                    continue;
                }
                if (nestedVarCount == 0) {
                    String varNameExpr = new String(chars, startPos + startMatchLen, pos - startPos - startMatchLen);
                    if (substitutionInVariablesEnabled) {
                        Builders bufName = new Builders(varNameExpr);
                        this.substitute(bufName, 0, bufName.length());
                        varNameExpr = bufName.toString();
                    }
                    int endPos = pos += endMatchLen;
                    String varName = varNameExpr;
                    String varDefaultValue = null;
                    if (null != valueDelimMatcher) {
                        char[] varNameExprChars = varNameExpr.toCharArray();
                        int valueDelimiterMatchLen = 0;
                        for (int i = 0; i < varNameExprChars.length && (substitutionInVariablesEnabled || pfxMatcher.isMatch(varNameExprChars, i, i, varNameExprChars.length) == 0); ++i) {
                            valueDelimiterMatchLen = valueDelimMatcher.isMatch(varNameExprChars, i);
                            if (valueDelimiterMatchLen == 0) continue;
                            varName = varNameExpr.substring(0, i);
                            varDefaultValue = varNameExpr.substring(i + valueDelimiterMatchLen);
                            break;
                        }
                    }
                    if (null == priorVariables) {
                        priorVariables = new ArrayList<String>();
                        priorVariables.add(new String(chars, offset, length));
                    }
                    this.checkCyclicSubstitution(varName, priorVariables);
                    priorVariables.add(varName);
                    String varValue = this.resolveVariable(varName, buffer, startPos, endPos);
                    if (null == varValue) {
                        varValue = varDefaultValue;
                    }
                    if (null != varValue) {
                        int varLen = varValue.length();
                        buffer.replace(startPos, endPos, varValue);
                        altered = true;
                        int change = this.substitute(buffer, startPos, varLen, priorVariables);
                        change = change + varLen - (endPos - startPos);
                        pos += change;
                        bufEnd += change;
                        lengthChange += change;
                        chars = buffer.buffer;
                    }
                    priorVariables.remove(priorVariables.size() - 1);
                    continue block0;
                }
                --nestedVarCount;
                pos += endMatchLen;
            }
        }
        if (top) {
            return altered ? 1 : 0;
        }
        return lengthChange;
    }

    private void checkCyclicSubstitution(String varName, List<String> priorVariables) {
        if (!priorVariables.contains(varName)) {
            return;
        }
        Builders buf = new Builders(256);
        buf.append("Infinite loop in property interpolation of ");
        buf.append(priorVariables.remove(0));
        buf.append(": ");
        buf.appendWithSeparators(priorVariables, "->");
        throw new IllegalStateException(buf.toString());
    }

    protected String resolveVariable(String variableName, Builders buf, int startPos, int endPos) {
        Lookups<?> resolver = this.getVariableResolver();
        if (null == resolver) {
            return null;
        }
        return resolver.lookup(variableName);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeCharacter) {
        this.escapeChar = escapeCharacter;
    }

    public Matchers getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public Replacers setVariablePrefixMatcher(Matchers prefixMatcher) {
        if (null == prefixMatcher) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = prefixMatcher;
        return this;
    }

    public Replacers setVariablePrefix(char prefix) {
        return this.setVariablePrefixMatcher(Matchers.charMatcher(prefix));
    }

    public Replacers setVariablePrefix(String prefix) {
        if (null == prefix) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(Matchers.stringMatcher(prefix));
    }

    public Matchers getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public Replacers setVariableSuffixMatcher(Matchers suffixMatcher) {
        if (null == suffixMatcher) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = suffixMatcher;
        return this;
    }

    public Replacers setVariableSuffix(char suffix) {
        return this.setVariableSuffixMatcher(Matchers.charMatcher(suffix));
    }

    public Replacers setVariableSuffix(String suffix) {
        if (null == suffix) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(Matchers.stringMatcher(suffix));
    }

    public Matchers getValueDelimiterMatcher() {
        return this.valueDelimiterMatcher;
    }

    public Replacers setValueDelimiterMatcher(Matchers valueDelimiterMatcher) {
        this.valueDelimiterMatcher = valueDelimiterMatcher;
        return this;
    }

    public Replacers setValueDelimiter(char valueDelimiter) {
        return this.setValueDelimiterMatcher(Matchers.charMatcher(valueDelimiter));
    }

    public Replacers setValueDelimiter(String valueDelimiter) {
        if (StringKit.isEmpty(valueDelimiter)) {
            this.setValueDelimiterMatcher(null);
            return this;
        }
        return this.setValueDelimiterMatcher(Matchers.stringMatcher(valueDelimiter));
    }

    public Lookups<?> getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(Lookups<?> variableResolver) {
        this.variableResolver = variableResolver;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public void setEnableSubstitutionInVariables(boolean enableSubstitutionInVariables) {
        this.enableSubstitutionInVariables = enableSubstitutionInVariables;
    }

    public boolean isPreserveEscapes() {
        return this.preserveEscapes;
    }

    public void setPreserveEscapes(boolean preserveEscapes) {
        this.preserveEscapes = preserveEscapes;
    }
}

