/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.aoju.bus.core.beans.BeanCache;
import org.aoju.bus.core.beans.BeanDescription;
import org.aoju.bus.core.beans.DynamicBean;
import org.aoju.bus.core.beans.PathExpression;
import org.aoju.bus.core.beans.PropertyCache;
import org.aoju.bus.core.beans.PropertyDescription;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.EscapeKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BeanKit {
    public static boolean isBean(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isReadable(Class<?> clazz) {
        return BeanKit.hasGetter(clazz) || BeanKit.hasPublicField(clazz);
    }

    public static boolean isEmpty(Object bean, String ... ignoreFiledNames) {
        if (null != bean) {
            for (Field field : ReflectKit.getFields(bean.getClass())) {
                if (BeanKit.isStatic(field) || ArrayKit.contains(ignoreFiledNames, field.getName()) || null == ReflectKit.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFiledNames) {
        return false == BeanKit.isEmpty(bean, ignoreFiledNames);
    }

    public static boolean hasNull(Object bean) {
        Field[] fields = ClassKit.getDeclaredFields(bean.getClass());
        Object fieldValue = null;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                fieldValue = field.get(bean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != fieldValue) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!BeanKit.isPublic(field) || BeanKit.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFiledNames) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectKit.getFields(bean.getClass())) {
            if (BeanKit.isStatic(field) || ArrayKit.contains(ignoreFiledNames, field.getName()) || null != ReflectKit.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullField(Object bean) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectKit.getFields(bean.getClass())) {
            if (null != ReflectKit.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }

    public static <T> T trimStrField(T bean, String ... ignoreField) {
        Field[] fields;
        if (null == bean) {
            return bean;
        }
        for (Field field : fields = ReflectKit.getFields(bean.getClass())) {
            String trimVal;
            String val;
            if (null != ignoreField && ArrayKit.containsIgnoreCase(ignoreField, field.getName()) || !String.class.equals(field.getType()) || null == (val = (String)ReflectKit.getFieldValue(bean, field)) || val.equals(trimVal = StringKit.trim(val))) continue;
            ReflectKit.setFieldValue(bean, field, (Object)trimVal);
        }
        return bean;
    }

    public static DynamicBean create(Object bean) {
        return new DynamicBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDescription getBeanDesc(Class<?> clazz) {
        BeanDescription beanDescription = BeanCache.INSTANCE.getBeanDesc(clazz);
        if (null == beanDescription) {
            beanDescription = new BeanDescription(clazz);
            BeanCache.INSTANCE.putBeanDesc(clazz, beanDescription);
        }
        return beanDescription;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws InstrumentException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new InstrumentException(e);
        }
        return ArrayKit.filter(beanInfo.getPropertyDescriptors(), t -> false == "class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) {
        return PropertyCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanKit.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) {
        PropertyDescriptor[] propertyDescriptors = BeanKit.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) {
        return BeanKit.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) {
        Map<String, PropertyDescriptor> map = BeanKit.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return CollKit.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return CollKit.map((Collection)bean, beanEle -> BeanKit.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (ArrayKit.isArray(bean)) {
            try {
                return ArrayKit.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return ArrayKit.map(bean, Object.class, beanEle -> BeanKit.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return ReflectKit.getFieldValue(bean, fieldNameOrIndex);
    }

    public static void setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            CollKit.setOrAppend((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else if (ArrayKit.isArray(bean)) {
            ArrayKit.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
        } else {
            ReflectKit.setFieldValue(bean, fieldNameOrIndex, value);
        }
    }

    public static Object getProperty(Object bean, String expression) {
        return PathExpression.create(expression).get(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        PathExpression.create(expression).set(bean, value);
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanKit.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        if (null == source) {
            return null;
        }
        T target = ReflectKit.newInstanceIfPossible(clazz);
        BeanKit.copyProperties(source, target, options);
        return target;
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == beanClass || null == valueProvider) {
            return null;
        }
        return BeanKit.fillBean(ReflectKit.newInstance(beanClass, new Object[0]), valueProvider, copyOptions);
    }

    public static <T> T toBeanIgnoreError(Object source, Class<T> clazz) {
        return BeanKit.toBean(source, clazz, CopyOptions.create().setIgnoreError(true));
    }

    public static <T> T toBeanIgnoreCase(Object source, Class<T> clazz, boolean ignoreError) {
        return BeanKit.toBean(source, clazz, CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanKit.fillBeanWithMap(map, ReflectKit.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        return BeanKit.fillBeanWithMap(map, ReflectKit.newInstance(beanClass, new Object[0]), copyOptions);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanKit.fillBeanWithMapIgnoreCase(map, ReflectKit.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanKit.fillBeanWithMap(map, bean, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanKit.fillBeanWithMap(map, bean, isToCamelCase, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanKit.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanKit.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapKit.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapKit.toCamelCaseMap(map);
        }
        return BeanCopier.create(map, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanKit.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanKit.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanKit.beanToMap(bean, targetMap, ignoreNullValue, key -> isToUnderlineCase ? StringKit.toUnderlineCase(key) : key);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (null == bean) {
            return null;
        }
        Collection<PropertyDescription> props = BeanKit.getBeanDesc(bean.getClass()).getProps();
        for (PropertyDescription prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ignoreNullValue && (null == value || value.equals(bean)) || null == (key = keyEditor.edit(key))) continue;
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T> T copyProperties(Object source, Class<T> clazz, String ... ignoreProperties) {
        T target = ReflectKit.newInstanceIfPossible(clazz);
        BeanKit.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
        return target;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanKit.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        BeanCopier.create(source, target, CopyOptions.create().setIgnoreCase(ignoreCase)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create(source, target, copyOptions).copy();
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        return ClassKit.getClassName(bean, isSimple).equals(isSimple ? StringKit.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        Field[] fields;
        if (null == bean) {
            return null;
        }
        for (Field field : fields = ReflectKit.getFields(bean.getClass())) {
            String trimVal;
            String val;
            if (BeanKit.isStatic(field) || null != ignoreFields && ArrayKit.containsIgnoreCase(ignoreFields, field.getName()) || !String.class.equals(field.getType()) || null == (val = (String)ReflectKit.getFieldValue(bean, field)) || val.equals(trimVal = StringKit.trim(val))) continue;
            ReflectKit.setFieldValue(bean, field, (Object)trimVal);
        }
        return bean;
    }

    public static void trimAllFields(Object bean) {
        try {
            if (null != bean) {
                Field[] fields;
                for (Field f : fields = bean.getClass().getDeclaredFields()) {
                    String key;
                    Object value;
                    if (!"java.lang.String".equals(f.getType().getName()) || null == (value = BeanKit.getFieldValue(bean, key = f.getName()))) continue;
                    BeanKit.setFieldValue(bean, key, EscapeKit.escapeXml11(value.toString()));
                }
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static void replaceStrFields(Object bean) {
        try {
            if (null != bean) {
                Field[] fields;
                for (Field f : fields = bean.getClass().getDeclaredFields()) {
                    String key;
                    Object value;
                    if (!"java.lang.String".equals(f.getType().getName()) || null == (value = BeanKit.getFieldValue(bean, key = f.getName()))) continue;
                    BeanKit.setFieldValue(bean, key, StringKit.replaceBlank(value.toString()));
                }
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        if (null == clazz || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & BeanKit.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Constructor<?> constructor, ModifierType ... modifierTypes) {
        if (null == constructor || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (constructor.getModifiers() & BeanKit.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Method method, ModifierType ... modifierTypes) {
        if (null == method || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (method.getModifiers() & BeanKit.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Field field, ModifierType ... modifierTypes) {
        if (null == field || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (field.getModifiers() & BeanKit.modifiersToInt(modifierTypes));
    }

    public static boolean isPublic(Field field) {
        return BeanKit.hasModifier(field, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Method method) {
        return BeanKit.hasModifier(method, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Class<?> clazz) {
        return BeanKit.hasModifier(clazz, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return BeanKit.hasModifier(constructor, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field) {
        return BeanKit.hasModifier(field, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return BeanKit.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isStatic(Class<?> clazz) {
        return BeanKit.hasModifier(clazz, ModifierType.STATIC);
    }

    private static int modifiersToInt(ModifierType ... modifierTypes) {
        int modifier = modifierTypes[0].getValue();
        for (int i = 1; i < modifierTypes.length; ++i) {
            modifier |= modifierTypes[i].getValue();
        }
        return modifier;
    }

    public static void forEach(Class<?> clazz, Consumer<? super PropertyDescription> action) {
        BeanKit.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        private ModifierType(int modifier) {
            this.value = modifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

