/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.aoju.bus.core.lang.Charset;

public class ByteKit {
    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return ByteKit.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return ByteKit.getBytes(intBits);
    }

    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(String data) {
        return ByteKit.getBytes(data, "GBK");
    }

    public static byte[] getBytes(String data, String charsetName) {
        return data.getBytes(Charset.charset(charsetName));
    }

    public static byte[] getBytes(char[] data) {
        CharBuffer cb = CharBuffer.allocate(data.length);
        cb.put(data);
        cb.flip();
        ByteBuffer bb = Charset.UTF_8.encode(cb);
        return bb.array();
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(ByteKit.getInt(bytes));
    }

    public static double getDouble(byte[] bytes) {
        return Double.longBitsToDouble(ByteKit.getLong(bytes));
    }

    public static short getShort(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static char getChar(byte[] bytes) {
        return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static String getString(byte[] bytes) {
        return ByteKit.getString(bytes, "GBK");
    }

    public static String getString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.charset(charsetName));
    }

    public static byte[][] split(byte[] arr, byte separator) {
        int count = ByteKit.countOf(arr, separator);
        byte[][] result = new byte[count + 1][];
        int index = ByteKit.indexOf(arr, separator, 0, arr.length);
        if (index < 0) {
            result[0] = arr;
        } else {
            result[0] = ByteKit.subArray(arr, 0, index);
            for (int i = 1; i <= count; ++i) {
                int from = index + 1;
                if ((index = ByteKit.indexOf(arr, separator, from, arr.length)) < from) {
                    index = arr.length;
                }
                result[i] = ByteKit.subArray(arr, from, index);
            }
        }
        return result;
    }

    public static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static byte[] subArray(byte[] arr, int from) {
        return ByteKit.subArray(arr, from, arr.length);
    }

    public static byte[] subArray(byte[] arr, int from, int to) {
        byte[] result = new byte[to - from];
        if (to > from) {
            System.arraycopy(arr, from, result, 0, result.length);
        }
        return result;
    }

    public static byte[] join(byte hyphen, byte[] ... arrs) {
        int length = 0;
        for (byte[] arr : arrs) {
            length += arr.length;
        }
        byte[] result = new byte[length + arrs.length - 1];
        int index = 0;
        for (int i = 0; i < arrs.length; ++i) {
            byte[] arr;
            arr = arrs[i];
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
            if (i >= arrs.length - 1) continue;
            result[index] = hyphen;
            ++index;
        }
        return result;
    }

    public static byte[] join(byte[] ... arrs) {
        int length = 0;
        for (byte[] arr : arrs) {
            length += arr.length;
        }
        byte[] result = new byte[length];
        int index = 0;
        for (byte[] arr : arrs) {
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
        }
        return result;
    }

    public static byte[] trim(byte[] src, byte empty) {
        return ByteKit.trim(src, empty, 0, src.length);
    }

    public static byte[] trim(byte[] src, byte empty, int from, int to) {
        while (from < src.length - 1 && src[from] == empty) {
            ++from;
        }
        while (to > from && src[to - 1] == empty) {
            --to;
        }
        return ByteKit.subArray(src, from, to);
    }

    public static int indexOf(byte[] arr, byte target, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (arr[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int countOf(byte[] arr, byte target) {
        int count = 0;
        for (byte b : arr) {
            if (b != target) continue;
            ++count;
        }
        return count;
    }

    public static String bcd(byte[] src, int from, int to) {
        char[] chars = new char[2 * (to - from)];
        for (int i = from; i < to; ++i) {
            int b = ByteKit.unsigned(src[i]);
            chars[2 * (i - from)] = (char)((b >> 4) + 48);
            chars[2 * (i - from) + 1] = (char)((b & 0xF) + 48);
        }
        return new String(chars);
    }

    public static int unsigned(byte value) {
        if (value >= 0) {
            return value;
        }
        return 256 + value;
    }

    public static int xor(byte[] bytes) {
        int temp = 0;
        if (null != bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                temp ^= bytes[i];
            }
        }
        return temp;
    }

    public static int bytesToVR(byte[] bytes, int off) {
        return ByteKit.bytesToUShortBE(bytes, off);
    }

    public static int bytesToUShort(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToUShortBE(bytes, off) : ByteKit.bytesToUShortLE(bytes, off);
    }

    public static int bytesToUShortBE(byte[] bytes, int off) {
        return ((bytes[off] & 0xFF) << 8) + (bytes[off + 1] & 0xFF);
    }

    public static int bytesToUShortLE(byte[] bytes, int off) {
        return ((bytes[off + 1] & 0xFF) << 8) + (bytes[off] & 0xFF);
    }

    public static int bytesToShortBE(byte[] bytes, int off) {
        return (bytes[off] << 8) + (bytes[off + 1] & 0xFF);
    }

    public static int bytesToShortLE(byte[] bytes, int off) {
        return (bytes[off + 1] << 8) + (bytes[off] & 0xFF);
    }

    public static void bytesToShortLE(byte[] b, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = b[boff + 1];
            int b1 = b[boff] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static void bytesToShortsBE(byte[] b, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = b[boff];
            int b1 = b[boff + 1] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static int bytesToShort(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToShortBE(bytes, off) : ByteKit.bytesToShortLE(bytes, off);
    }

    public static void bytesToShort(byte[] b, short[] s, int off, int len, boolean bigEndian) {
        if (bigEndian) {
            ByteKit.bytesToShortsBE(b, s, off, len);
        } else {
            ByteKit.bytesToShortLE(b, s, off, len);
        }
    }

    public static int bytesToInt(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToIntBE(bytes, off) : ByteKit.bytesToIntLE(bytes, off);
    }

    public static int bytesToIntBE(byte[] bytes, int off) {
        return (bytes[off] << 24) + ((bytes[off + 1] & 0xFF) << 16) + ((bytes[off + 2] & 0xFF) << 8) + (bytes[off + 3] & 0xFF);
    }

    public static int bytesToIntLE(byte[] bytes, int off) {
        return (bytes[off + 3] << 24) + ((bytes[off + 2] & 0xFF) << 16) + ((bytes[off + 1] & 0xFF) << 8) + (bytes[off] & 0xFF);
    }

    public static int bytesToTag(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToTagBE(bytes, off) : ByteKit.bytesToTagLE(bytes, off);
    }

    public static int bytesToTagBE(byte[] bytes, int off) {
        return ByteKit.bytesToIntBE(bytes, off);
    }

    public static int bytesToTagLE(byte[] bytes, int off) {
        return (bytes[off + 1] << 24) + ((bytes[off] & 0xFF) << 16) + ((bytes[off + 3] & 0xFF) << 8) + (bytes[off + 2] & 0xFF);
    }

    public static float bytesToFloat(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToFloatBE(bytes, off) : ByteKit.bytesToFloatLE(bytes, off);
    }

    public static float bytesToFloatBE(byte[] bytes, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntBE(bytes, off));
    }

    public static float bytesToFloatLE(byte[] bytes, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntLE(bytes, off));
    }

    public static long bytesToLong(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToLongBE(bytes, off) : ByteKit.bytesToLongLE(bytes, off);
    }

    public static long bytesToLongBE(byte[] bytes, int off) {
        return ((long)bytes[off] << 56) + ((long)(bytes[off + 1] & 0xFF) << 48) + ((long)(bytes[off + 2] & 0xFF) << 40) + ((long)(bytes[off + 3] & 0xFF) << 32) + ((long)(bytes[off + 4] & 0xFF) << 24) + (long)((bytes[off + 5] & 0xFF) << 16) + (long)((bytes[off + 6] & 0xFF) << 8) + (long)(bytes[off + 7] & 0xFF);
    }

    public static long bytesToLongLE(byte[] bytes, int off) {
        return ((long)bytes[off + 7] << 56) + ((long)(bytes[off + 6] & 0xFF) << 48) + ((long)(bytes[off + 5] & 0xFF) << 40) + ((long)(bytes[off + 4] & 0xFF) << 32) + ((long)(bytes[off + 3] & 0xFF) << 24) + (long)((bytes[off + 2] & 0xFF) << 16) + (long)((bytes[off + 1] & 0xFF) << 8) + (long)(bytes[off] & 0xFF);
    }

    public static double bytesToDouble(byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToDoubleBE(bytes, off) : ByteKit.bytesToDoubleLE(bytes, off);
    }

    public static double bytesToDoubleBE(byte[] bytes, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongBE(bytes, off));
    }

    public static double bytesToDoubleLE(byte[] bytes, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongLE(bytes, off));
    }

    public static byte[] shortToBytes(int i, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.shortToBytesBE(i, bytes, off) : ByteKit.shortToBytesLE(i, bytes, off);
    }

    public static byte[] shortToBytesBE(int i, byte[] bytes, int off) {
        bytes[off] = (byte)(i >> 8);
        bytes[off + 1] = (byte)i;
        return bytes;
    }

    public static byte[] shortToBytesLE(int i, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(i >> 8);
        bytes[off] = (byte)i;
        return bytes;
    }

    public static byte[] intToBytes(int i, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.intToBytesBE(i, bytes, off) : ByteKit.intToBytesLE(i, bytes, off);
    }

    public static byte[] intToBytesBE(int i, byte[] bytes, int off) {
        bytes[off] = (byte)(i >> 24);
        bytes[off + 1] = (byte)(i >> 16);
        bytes[off + 2] = (byte)(i >> 8);
        bytes[off + 3] = (byte)i;
        return bytes;
    }

    public static byte[] intToBytesLE(int i, byte[] bytes, int off) {
        bytes[off + 3] = (byte)(i >> 24);
        bytes[off + 2] = (byte)(i >> 16);
        bytes[off + 1] = (byte)(i >> 8);
        bytes[off] = (byte)i;
        return bytes;
    }

    public static byte[] tagToBytes(int i, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.tagToBytesBE(i, bytes, off) : ByteKit.tagToBytesLE(i, bytes, off);
    }

    public static byte[] tagToBytesBE(int i, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(i, bytes, off);
    }

    public static byte[] tagToBytesLE(int i, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(i >> 24);
        bytes[off] = (byte)(i >> 16);
        bytes[off + 3] = (byte)(i >> 8);
        bytes[off + 2] = (byte)i;
        return bytes;
    }

    public static byte[] floatToBytes(float f, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.floatToBytesBE(f, bytes, off) : ByteKit.floatToBytesLE(f, bytes, off);
    }

    public static byte[] floatToBytesBE(float f, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(Float.floatToIntBits(f), bytes, off);
    }

    public static byte[] floatToBytesLE(float f, byte[] bytes, int off) {
        return ByteKit.intToBytesLE(Float.floatToIntBits(f), bytes, off);
    }

    public static byte[] doubleToBytes(double d, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.doubleToBytesBE(d, bytes, off) : ByteKit.doubleToBytesLE(d, bytes, off);
    }

    public static byte[] doubleToBytesBE(double d, byte[] bytes, int off) {
        return ByteKit.longToBytesBE(Double.doubleToLongBits(d), bytes, off);
    }

    public static byte[] doubleToBytesLE(double d, byte[] bytes, int off) {
        return ByteKit.longToBytesLE(Double.doubleToLongBits(d), bytes, off);
    }

    public static byte[] longToBytes(long l, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.longToBytesBE(l, bytes, off) : ByteKit.longToBytesLE(l, bytes, off);
    }

    public static byte[] longToBytesBE(long l, byte[] bytes, int off) {
        bytes[off] = (byte)(l >> 56);
        bytes[off + 1] = (byte)(l >> 48);
        bytes[off + 2] = (byte)(l >> 40);
        bytes[off + 3] = (byte)(l >> 32);
        bytes[off + 4] = (byte)(l >> 24);
        bytes[off + 5] = (byte)(l >> 16);
        bytes[off + 6] = (byte)(l >> 8);
        bytes[off + 7] = (byte)l;
        return bytes;
    }

    public static byte[] longToBytesLE(long l, byte[] bytes, int off) {
        bytes[off + 7] = (byte)(l >> 56);
        bytes[off + 6] = (byte)(l >> 48);
        bytes[off + 5] = (byte)(l >> 40);
        bytes[off + 4] = (byte)(l >> 32);
        bytes[off + 3] = (byte)(l >> 24);
        bytes[off + 2] = (byte)(l >> 16);
        bytes[off + 1] = (byte)(l >> 8);
        bytes[off] = (byte)l;
        return bytes;
    }

    public static byte[][] swapShorts(byte[][] bs) {
        int carry = 0;
        for (int i = 0; i < bs.length; ++i) {
            byte[] b = bs[i];
            if (carry != 0) {
                ByteKit.swapLastFirst(bs[i - 1], b);
            }
            int len = b.length - carry;
            ByteKit.swapShorts(b, carry, len & 0xFFFFFFFE);
            carry = len & 1;
        }
        return bs;
    }

    public static byte[] swapShorts(byte[] b, int off, int len) {
        ByteKit.checkLength(len, 2);
        int n = off + len;
        for (int i = off; i < n; i += 2) {
            ByteKit.swap(b, i, i + 1);
        }
        return b;
    }

    public static byte[] swapInts(byte[] b, int off, int len) {
        ByteKit.checkLength(len, 4);
        int n = off + len;
        for (int i = off; i < n; i += 4) {
            ByteKit.swap(b, i, i + 3);
            ByteKit.swap(b, i + 1, i + 2);
        }
        return b;
    }

    public static byte[] swapLongs(byte[] b, int off, int len) {
        ByteKit.checkLength(len, 8);
        int n = off + len;
        for (int i = off; i < n; i += 8) {
            ByteKit.swap(b, i, i + 7);
            ByteKit.swap(b, i + 1, i + 6);
            ByteKit.swap(b, i + 2, i + 5);
            ByteKit.swap(b, i + 3, i + 4);
        }
        return b;
    }

    private static void checkLength(int len, int numBytes) {
        if (len < 0 || len % numBytes != 0) {
            throw new IllegalArgumentException("length: " + len);
        }
    }

    private static void swap(byte[] bytes, int a, int b) {
        byte t = bytes[a];
        bytes[a] = bytes[b];
        bytes[b] = t;
    }

    private static void swapLastFirst(byte[] b1, byte[] b2) {
        int last = b1.length - 1;
        byte t = b2[0];
        b2[0] = b1[last];
        b1[last] = t;
    }

    public static byte[] intsToBytesLE(int ... values) {
        byte[] ret = new byte[4 * values.length];
        for (int i = 0; i < values.length; ++i) {
            ByteKit.intToBytesLE(values[i], ret, 4 * i);
        }
        return ret;
    }

    public static byte[] concat(byte[] buf1, byte[] buf2) {
        byte[] buffer = new byte[buf1.length + buf2.length];
        int offset = 0;
        System.arraycopy(buf1, 0, buffer, offset, buf1.length);
        System.arraycopy(buf2, 0, buffer, offset += buf1.length, buf2.length);
        return buffer;
    }
}

