/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.aoju.bus.core.codec.BCD;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.Keys;

public abstract class Safety<T extends Safety<T>>
extends Keys<T> {
    public Safety(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public abstract byte[] encrypt(byte[] var1, KeyType var2);

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexKit.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StringKit.bytes((CharSequence)data, Charset.UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexKit.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptHex(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return HexKit.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws InstrumentException {
        return this.encrypt(IoKit.readBytes(data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexKit.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, Charset.UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return BCD.bcdToStr(this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyType var2);

    public byte[] decrypt(InputStream data, KeyType keyType) throws InstrumentException {
        return this.decrypt(IoKit.readBytes(data), keyType);
    }

    public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(Builder.decode(data), keyType);
    }

    public String decryptStr(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringKit.toString(this.decrypt(data, keyType), charset);
    }

    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, Charset.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, Charset.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        Assert.notNull(data, "Bcd string must be not null!", new Object[0]);
        byte[] dataBytes = BCD.ascToBcd(StringKit.bytes((CharSequence)data, charset));
        return this.decrypt(dataBytes, keyType);
    }

    public String decryptStrFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringKit.toString(this.decryptFromBcd(data, keyType, charset), charset);
    }

    public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, Charset.UTF_8);
    }
}

