/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface TerminalVersion {
    public int[] terminals() default {};

    public Version op() default Version.NIL;

    public String version() default "";

    public static enum Version {
        NIL(""),
        LT("<"),
        GT(">"),
        GTE(">="),
        LE("<="),
        LTE("<=="),
        GE(">="),
        NE("!="),
        EQ("==");

        private final String code;

        private Version(String code) {
            this.code = code;
        }

        public static Version parse(String code) {
            for (Version operator : Version.values()) {
                if (!operator.getCode().equalsIgnoreCase(code)) continue;
                return operator;
            }
            return null;
        }

        public String getCode() {
            return this.code;
        }
    }
}

