/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.entity.OAuth2;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.Assets;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.goalie.metric.Authorize;
import org.aoju.bus.goalie.metric.Delegate;
import org.aoju.bus.goalie.metric.Token;
import org.aoju.bus.goalie.registry.AssetsRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483646)
public class AuthorizeFilter
implements WebFilter {
    private final Authorize authorize;
    private final AssetsRegistry registry;

    public AuthorizeFilter(Authorize authorize, AssetsRegistry registry) {
        this.authorize = authorize;
        this.registry = registry;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Context context = Context.get(exchange);
        Map<String, String> params = context.getRequestMap();
        context.setFormat(Context.Format.valueOf(params.get("format")));
        context.setChannel(Context.Channel.getChannel(params.get("x_remote_channel")));
        context.setToken(exchange.getRequest().getHeaders().getFirst("X-Access-Token"));
        String method = params.get("method");
        String version = params.get("v");
        Assets assets = this.registry.getAssets(method, version);
        if (null == assets) {
            return Mono.error((Throwable)new BusinessException(ErrorCode.EM_100500));
        }
        this.checkMethod(exchange.getRequest(), assets);
        this.checkTokenIfNecessary(context, assets, params);
        this.fillXParam(exchange, params);
        this.cleanParam(params);
        context.setAssets(assets);
        return chain.filter(exchange);
    }

    private void checkMethod(ServerHttpRequest request, Assets assets) {
        if (!Objects.equals(request.getMethod(), assets.getHttpMethod())) {
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.GET)) {
                throw new BusinessException(ErrorCode.EM_100200);
            }
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.POST)) {
                throw new BusinessException(ErrorCode.EM_100201);
            }
            throw new BusinessException(ErrorCode.EM_100508);
        }
    }

    private void checkTokenIfNecessary(Context context, Assets assets, Map<String, String> params) {
        if (assets.isToken()) {
            if (StringKit.isBlank(context.getToken())) {
                throw new BusinessException(ErrorCode.EM_100106);
            }
            Token access = new Token(context.getToken(), context.getChannel().getTokenType());
            Delegate delegate = this.authorize.authorize(access);
            if (delegate.isOk()) {
                OAuth2 auth2 = delegate.getOAuth2();
                Map<String, Object> map = BeanKit.beanToMap(auth2, false, true);
                map.forEach((k, v) -> params.put((String)k, v.toString()));
            } else {
                throw new BusinessException(delegate.getMessage().errcode, delegate.getMessage().errmsg);
            }
        }
    }

    private void cleanParam(Map<String, String> params) {
        params.remove("method");
        params.remove("format");
        params.remove("v");
    }

    private void fillXParam(ServerWebExchange exchange, Map<String, String> requestParam) {
        InetSocketAddress address;
        String ip = exchange.getRequest().getHeaders().getFirst("x_remote_ip");
        if (StringKit.isBlank(ip) && null != (address = exchange.getRequest().getRemoteAddress())) {
            ip = address.getAddress().getHostAddress();
        }
        requestParam.put("x_remote_ip", ip);
    }
}

