/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOperatingSystem;
import org.aoju.bus.health.builtin.software.FileSystem;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.builtin.software.NetworkParams;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSService;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.linux.LinuxLibc;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.drivers.CpuStat;
import org.aoju.bus.health.linux.drivers.ProcessStat;
import org.aoju.bus.health.linux.drivers.UpTime;
import org.aoju.bus.health.linux.drivers.Who;
import org.aoju.bus.health.linux.software.LinuxFileSystem;
import org.aoju.bus.health.linux.software.LinuxInternetProtocolStats;
import org.aoju.bus.health.linux.software.LinuxNetworkParams;
import org.aoju.bus.health.linux.software.LinuxOSProcess;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class LinuxOperatingSystem
extends AbstractOperatingSystem {
    static final long BOOTTIME;
    private static final String OS_RELEASE_LOG = "os-release: {}";
    private static final String LSB_RELEASE_A_LOG = "lsb_release -a: {}";
    private static final String LSB_RELEASE_LOG = "lsb-release: {}";
    private static final String RELEASE_DELIM = " release ";
    private static final String DOUBLE_QUOTES = "(?:^\")|(?:\"$)";
    private static final long USER_HZ;
    private static final int[] PPID_INDEX;

    private static int getParentPidFromProcFile(int pid) {
        String stat = Builder.getStringFromFile(String.format("/proc/%d/stat", pid));
        if (stat.isEmpty()) {
            return 0;
        }
        long[] statArray = Builder.parseStringToLongArray(stat, PPID_INDEX, ProcessStat.PROC_PID_STAT_LENGTH, ' ');
        return (int)statArray[0];
    }

    protected static String getReleaseFilename() {
        File etc = new File("/etc");
        File[] matchingFiles = etc.listFiles(f -> (f.getName().endsWith("-release") || f.getName().endsWith("-version") || f.getName().endsWith("_release") || f.getName().endsWith("_version")) && !f.getName().endsWith("os-release") && !f.getName().endsWith("lsb-release") && !f.getName().endsWith("system-release"));
        if (null != matchingFiles && matchingFiles.length > 0) {
            return matchingFiles[0].getPath();
        }
        if (new File("/etc/release").exists()) {
            return "/etc/release";
        }
        return "/etc/issue";
    }

    public static long getHz() {
        return USER_HZ;
    }

    private static String filenameToFamily(String name) {
        switch (name.toLowerCase()) {
            case "": {
                return "Solaris";
            }
            case "blackcat": {
                return "Black Cat";
            }
            case "bluewhite64": {
                return "BlueWhite64";
            }
            case "e-smith": {
                return "SME Server";
            }
            case "eos": {
                return "FreeEOS";
            }
            case "hlfs": {
                return "HLFS";
            }
            case "lfs": {
                return "Linux-From-Scratch";
            }
            case "linuxppc": {
                return "Linux-PPC";
            }
            case "meego": {
                return "MeeGo";
            }
            case "mandakelinux": {
                return "Mandrake";
            }
            case "mklinux": {
                return "MkLinux";
            }
            case "nld": {
                return "Novell Linux Desktop";
            }
            case "novell": 
            case "SuSE": {
                return "SUSE Linux";
            }
            case "pld": {
                return "PLD";
            }
            case "redhat": {
                return "Red Hat Linux";
            }
            case "sles": {
                return "SUSE Linux ES9";
            }
            case "sun": {
                return "Sun JDS";
            }
            case "synoinfo": {
                return "Synology";
            }
            case "tinysofa": {
                return "Tiny Sofa";
            }
            case "turbolinux": {
                return "TurboLinux";
            }
            case "ultrapenguin": {
                return "UltraPenguin";
            }
            case "va": {
                return "VA-Linux";
            }
            case "vmware": {
                return "VMWareESX";
            }
            case "yellowdog": {
                return "Yellow Dog";
            }
            case "issue": {
                return "Unknown";
            }
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static List<OSProcess> queryProcessList(Set<Integer> descendantPids) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int pid : descendantPids) {
            LinuxOSProcess proc = new LinuxOSProcess(pid);
            if (proc.getState().equals((Object)OSProcess.State.INVALID)) continue;
            procs.add(proc);
        }
        return procs;
    }

    private static Map<Integer, Integer> getParentPidsFromProcFiles(File[] pidFiles) {
        HashMap<Integer, Integer> parentPidMap = new HashMap<Integer, Integer>();
        for (File procFile : pidFiles) {
            int pid = Builder.parseIntOrDefault(procFile.getName(), 0);
            parentPidMap.put(pid, LinuxOperatingSystem.getParentPidFromProcFile(pid));
        }
        return parentPidMap;
    }

    @Override
    public String queryManufacturer() {
        return "GNU/Linux";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        Triple<String, String, String> familyVersionCodename = LinuxOperatingSystem.queryFamilyVersionCodenameFromReleaseFiles();
        String buildNumber = null;
        List<String> procVersion = FileKit.readLines(ProcPath.VERSION);
        if (!procVersion.isEmpty()) {
            String[] split;
            for (String s : split = RegEx.SPACES.split(procVersion.get(0))) {
                if ("Linux".equals(s) || "version".equals(s)) continue;
                buildNumber = s;
                break;
            }
        }
        OperatingSystem.OSVersionInfo versionInfo = new OperatingSystem.OSVersionInfo(familyVersionCodename.getMiddle(), familyVersionCodename.getRight(), buildNumber);
        return Pair.of(familyVersionCodename.getLeft(), versionInfo);
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness < 64 && Executor.getFirstAnswer("uname -m").indexOf("64") == -1) {
            return jvmBitness;
        }
        return 64;
    }

    @Override
    public FileSystem getFileSystem() {
        return new LinuxFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new LinuxInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        return USE_WHO_COMMAND ? super.getSessions() : Who.queryUtxent();
    }

    @Override
    public OSProcess getProcess(int pid) {
        LinuxOSProcess proc = new LinuxOSProcess(pid);
        if (!proc.getState().equals((Object)OSProcess.State.INVALID)) {
            return proc;
        }
        return null;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.queryChildProcesses(-1);
    }

    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        File[] pidFiles = ProcessStat.getPidFiles();
        if (parentPid >= 0) {
            return LinuxOperatingSystem.queryProcessList(LinuxOperatingSystem.getChildrenOrDescendants(LinuxOperatingSystem.getParentPidsFromProcFiles(pidFiles), parentPid, false));
        }
        HashSet<Integer> descendantPids = new HashSet<Integer>();
        for (File procFile : pidFiles) {
            int pid = Builder.parseIntOrDefault(procFile.getName(), -2);
            if (pid == -2) continue;
            descendantPids.add(pid);
        }
        return LinuxOperatingSystem.queryProcessList(descendantPids);
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        File[] pidFiles = ProcessStat.getPidFiles();
        return LinuxOperatingSystem.queryProcessList(LinuxOperatingSystem.getChildrenOrDescendants(LinuxOperatingSystem.getParentPidsFromProcFiles(pidFiles), parentPid, true));
    }

    @Override
    public int getProcessId() {
        return LinuxLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcessStat.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        try {
            LibC.Sysinfo info = new LibC.Sysinfo();
            if (0 != LibC.INSTANCE.sysinfo(info)) {
                Logger.error("Failed to get process thread count. Error code: {}", Native.getLastError());
                return 0;
            }
            return info.procs;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            Logger.error("Failed to get procs from sysinfo. {}", e.getMessage());
            return 0;
        }
    }

    @Override
    public long getSystemUptime() {
        return (long)UpTime.getSystemUptimeSeconds();
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    private static Triple<String, String, String> queryFamilyVersionCodenameFromReleaseFiles() {
        Triple<String, String, String> familyVersionCodename = LinuxOperatingSystem.readDistribRelease("/etc/system-release");
        if (null != familyVersionCodename) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.readOsRelease();
        if (null != familyVersionCodename) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.execLsbRelease();
        if (null != familyVersionCodename) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.readLsbRelease();
        if (null != familyVersionCodename) {
            return familyVersionCodename;
        }
        String etcDistribRelease = LinuxOperatingSystem.getReleaseFilename();
        familyVersionCodename = LinuxOperatingSystem.readDistribRelease(etcDistribRelease);
        if (null != familyVersionCodename) {
            return familyVersionCodename;
        }
        String family = LinuxOperatingSystem.filenameToFamily(etcDistribRelease.replace("/etc/", "").replace("release", "").replace("version", "").replace("-", "").replace("_", ""));
        return Triple.of(family, "unknown", "unknown");
    }

    private static Triple<String, String, String> readOsRelease() {
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        List<String> osRelease = FileKit.readLines("/etc/os-release");
        for (String line : osRelease) {
            if (line.startsWith("VERSION=")) {
                Logger.debug(OS_RELEASE_LOG, line);
                line = line.replace("VERSION=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                String[] split = line.split("[()]");
                if (split.length <= 1) {
                    split = line.split(", ");
                }
                if (split.length > 0) {
                    versionId = split[0].trim();
                }
                if (split.length <= 1) continue;
                codeName = split[1].trim();
                continue;
            }
            if (line.startsWith("NAME=") && null == family) {
                Logger.debug(OS_RELEASE_LOG, line);
                family = line.replace("NAME=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (!line.startsWith("VERSION_ID=") || !versionId.equals("unknown")) continue;
            Logger.debug(OS_RELEASE_LOG, line);
            versionId = line.replace("VERSION_ID=", "").replaceAll(DOUBLE_QUOTES, "").trim();
        }
        return null == family ? null : Triple.of(family, versionId, codeName);
    }

    private static Triple<String, String, String> execLsbRelease() {
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        for (String line : Executor.runNative("lsb_release -a")) {
            if (line.startsWith("Description:")) {
                Logger.debug(LSB_RELEASE_A_LOG, line);
                if (!(line = line.replace("Description:", "").trim()).contains(RELEASE_DELIM)) continue;
                Triple<String, String, String> Triple2 = LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                family = Triple2.getLeft();
                if (versionId.equals("unknown")) {
                    versionId = Triple2.getMiddle();
                }
                if (!codeName.equals("unknown")) continue;
                codeName = Triple2.getRight();
                continue;
            }
            if (line.startsWith("Distributor ID:") && null == family) {
                Logger.debug(LSB_RELEASE_A_LOG, line);
                family = line.replace("Distributor ID:", "").trim();
                continue;
            }
            if (line.startsWith("Release:") && versionId.equals("unknown")) {
                Logger.debug(LSB_RELEASE_A_LOG, line);
                versionId = line.replace("Release:", "").trim();
                continue;
            }
            if (!line.startsWith("Codename:") || !codeName.equals("unknown")) continue;
            Logger.debug(LSB_RELEASE_A_LOG, line);
            codeName = line.replace("Codename:", "").trim();
        }
        return null == family ? null : Triple.of(family, versionId, codeName);
    }

    private static Triple<String, String, String> readLsbRelease() {
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        List<String> osRelease = FileKit.readLines("/etc/lsb-release");
        for (String line : osRelease) {
            if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                Logger.debug(LSB_RELEASE_LOG, line);
                if (!(line = line.replace("DISTRIB_DESCRIPTION=", "").replaceAll(DOUBLE_QUOTES, "").trim()).contains(RELEASE_DELIM)) continue;
                Triple<String, String, String> Triple2 = LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                family = Triple2.getLeft();
                if (versionId.equals("unknown")) {
                    versionId = Triple2.getMiddle();
                }
                if (!codeName.equals("unknown")) continue;
                codeName = Triple2.getRight();
                continue;
            }
            if (line.startsWith("DISTRIB_ID=") && null == family) {
                Logger.debug(LSB_RELEASE_LOG, line);
                family = line.replace("DISTRIB_ID=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (line.startsWith("DISTRIB_RELEASE=") && versionId.equals("unknown")) {
                Logger.debug(LSB_RELEASE_LOG, line);
                versionId = line.replace("DISTRIB_RELEASE=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (!line.startsWith("DISTRIB_CODENAME=") || !codeName.equals("unknown")) continue;
            Logger.debug(LSB_RELEASE_LOG, line);
            codeName = line.replace("DISTRIB_CODENAME=", "").replaceAll(DOUBLE_QUOTES, "").trim();
        }
        return null == family ? null : Triple.of(family, versionId, codeName);
    }

    private static Triple<String, String, String> readDistribRelease(String filename) {
        if (new File(filename).exists()) {
            List<String> osRelease = FileKit.readLines(filename);
            for (String line : osRelease) {
                Logger.debug("{}: {}", filename, line);
                if (line.contains(RELEASE_DELIM)) {
                    return LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                }
                if (!line.contains(" VERSION ")) continue;
                return LinuxOperatingSystem.parseRelease(line, " VERSION ");
            }
        }
        return null;
    }

    private static Triple<String, String, String> parseRelease(String line, String splitLine) {
        String[] split = line.split(splitLine);
        String family = split[0].trim();
        String versionId = "unknown";
        String codeName = "unknown";
        if (split.length > 1) {
            if ((split = split[1].split("[()]")).length > 0) {
                versionId = split[0].trim();
            }
            if (split.length > 1) {
                codeName = split[1].trim();
            }
        }
        return Triple.of(family, versionId, codeName);
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new LinuxNetworkParams();
    }

    @Override
    public OSService[] getServices() {
        ArrayList<Object> services = new ArrayList<Object>();
        HashSet<String> running = new HashSet<String>();
        for (OSProcess p : this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0)) {
            OSService s = new OSService(p.getName(), p.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(p.getName());
        }
        boolean systemctlFound = false;
        List<String> systemctl = Executor.runNative("systemctl list-unit-files");
        for (String str : systemctl) {
            String shortName;
            String[] split = RegEx.SPACES.split(str);
            if (split.length < 2 || !split[0].endsWith(".service") || !"enabled".equals(split[1])) continue;
            String name2 = split[0].substring(0, split[0].length() - 8);
            int index = name2.lastIndexOf(46);
            String string = shortName = index < 0 || index > name2.length() - 2 ? name2 : name2.substring(index + 1);
            if (running.contains(name2) || running.contains(shortName)) continue;
            OSService s = new OSService(name2, 0, OSService.State.STOPPED);
            services.add(s);
            systemctlFound = true;
        }
        if (!systemctlFound) {
            File dir = new File("/etc/init");
            if (dir.exists() && dir.isDirectory()) {
                for (File f2 : dir.listFiles((f, name) -> name.toLowerCase().endsWith(".conf"))) {
                    String shortName;
                    String name3 = f2.getName().substring(0, f2.getName().length() - 5);
                    int index = name3.lastIndexOf(46);
                    String string = shortName = index < 0 || index > name3.length() - 2 ? name3 : name3.substring(index + 1);
                    if (running.contains(name3) || running.contains(shortName)) continue;
                    OSService s = new OSService(name3, 0, OSService.State.STOPPED);
                    services.add(s);
                }
            } else {
                Logger.error("Directory: /etc/init does not exist", new Object[0]);
            }
        }
        return services.toArray(new OSService[0]);
    }

    static {
        USER_HZ = Builder.parseLongOrDefault(Executor.getFirstAnswer("getconf CLK_TCK"), 100L);
        PPID_INDEX = new int[]{3};
        long tempBT = CpuStat.getBootTime();
        if (tempBT == 0L) {
            tempBT = System.currentTimeMillis() / 1000L - (long)UpTime.getSystemUptimeSeconds();
        }
        BOOTTIME = tempBT;
    }
}

