/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quartet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractBaseboard;

@Immutable
final class MacBaseboard
extends AbstractBaseboard {
    private final Supplier<Quartet<String, String, String, String>> manufModelVersSerial = Memoize.memoize(MacBaseboard::queryPlatform);

    MacBaseboard() {
    }

    private static Quartet<String, String, String, String> queryPlatform() {
        String manufacturer = null;
        String model = null;
        String version = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (null != platformExpert) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (null != data) {
                manufacturer = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (null != (data = platformExpert.getByteArrayProperty("board-id"))) {
                model = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (StringKit.isBlank(model) && null != (data = platformExpert.getByteArrayProperty("model-number"))) {
                model = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (null != (data = platformExpert.getByteArrayProperty("version"))) {
                version = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (null != (data = platformExpert.getByteArrayProperty("mlb-serial-number"))) {
                serialNumber = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (StringKit.isBlank(serialNumber)) {
                serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            }
            platformExpert.release();
        }
        return new Quartet<String, String, String, String>(StringKit.isBlank(manufacturer) ? "Apple Inc." : manufacturer, StringKit.isBlank(model) ? "unknown" : model, StringKit.isBlank(version) ? "unknown" : version, StringKit.isBlank(serialNumber) ? "unknown" : serialNumber);
    }

    @Override
    public String getManufacturer() {
        return this.manufModelVersSerial.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufModelVersSerial.get().getB();
    }

    @Override
    public String getVersion() {
        return this.manufModelVersSerial.get().getC();
    }

    @Override
    public String getSerialNumber() {
        return this.manufModelVersSerial.get().getD();
    }
}

