/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.builtin.hardware.AbstractSoundCard;
import org.aoju.bus.health.builtin.hardware.SoundCard;

@Immutable
final class AixSoundCard
extends AbstractSoundCard {
    AixSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<SoundCard> getSoundCards(Supplier<List<String>> lscfg) {
        ArrayList<SoundCard> soundCards = new ArrayList<SoundCard>();
        for (String line : lscfg.get()) {
            String[] split;
            String s = line.trim();
            if (!s.startsWith("paud") || (split = RegEx.SPACES.split(s, 3)).length != 3) continue;
            soundCards.add(new AixSoundCard("unknown", split[2], "unknown"));
        }
        return soundCards;
    }
}

