/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractOperatingSystem;
import org.aoju.bus.health.builtin.software.FileSystem;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.builtin.software.NetworkParams;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSService;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.unix.aix.AixLibc;
import org.aoju.bus.health.unix.aix.drivers.Uptime;
import org.aoju.bus.health.unix.aix.drivers.Who;
import org.aoju.bus.health.unix.aix.drivers.perfstat.PerfstatConfig;
import org.aoju.bus.health.unix.aix.drivers.perfstat.PerfstatProcess;
import org.aoju.bus.health.unix.aix.software.AixFileSystem;
import org.aoju.bus.health.unix.aix.software.AixInternetProtocolStats;
import org.aoju.bus.health.unix.aix.software.AixNetworkParams;
import org.aoju.bus.health.unix.aix.software.AixOSProcess;

@ThreadSafe
public class AixOperatingSystem
extends AbstractOperatingSystem {
    private static final long BOOTTIME = AixOperatingSystem.querySystemBootTimeMillis() / 1000L;
    private final Supplier<Perfstat.perfstat_partition_config_t> config = Memoize.memoize(PerfstatConfig::queryConfig);
    Supplier<Perfstat.perfstat_process_t[]> procCpu = Memoize.memoize(PerfstatProcess::queryProcesses, Memoize.defaultExpiration());

    @Override
    public String queryManufacturer() {
        return "IBM";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String releaseNumber;
        Perfstat.perfstat_partition_config_t cfg = this.config.get();
        String systemName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        String versionNumber = System.getProperty("os.version");
        if (StringKit.isBlank(versionNumber)) {
            versionNumber = Executor.getFirstAnswer("oslevel");
        }
        if (StringKit.isBlank(releaseNumber = Native.toString((byte[])cfg.OSBuild))) {
            releaseNumber = Executor.getFirstAnswer("oslevel -s");
        } else {
            int idx = releaseNumber.lastIndexOf(32);
            if (idx > 0 && idx < releaseNumber.length()) {
                releaseNumber = releaseNumber.substring(idx + 1);
            }
        }
        return Pair.of(systemName, new OperatingSystem.OSVersionInfo(versionNumber, archName, releaseNumber));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness == 64) {
            return 64;
        }
        return (this.config.get().conf & 0x800000) > 0 ? 64 : 32;
    }

    @Override
    public FileSystem getFileSystem() {
        return new AixFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new AixInternetProtocolStats();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.getProcessListFromPS("ps -A -o st,pid,ppid,user,uid,group,gid,thcount,pri,vsize,rssize,etime,time,comm,pagein,args", -1);
    }

    private static long querySystemBootTimeMillis() {
        long bootTime = Who.queryBootTime();
        if (bootTime >= 1000L) {
            return bootTime;
        }
        return System.currentTimeMillis() - Uptime.queryUpTime();
    }

    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = AixOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -o st,pid,ppid,user,uid,group,gid,thcount,pri,vsize,rssize,etime,time,comm,pagein,args -p ", pid);
        if (procs.isEmpty()) {
            return null;
        }
        return procs.get(0);
    }

    private List<OSProcess> getProcessListFromPS(String psCommand, int pid) {
        Perfstat.perfstat_process_t[] perfstat = this.procCpu.get();
        List<String> procList = Executor.runNative(psCommand + (pid < 0 ? "" : Integer.valueOf(pid)));
        if (procList.isEmpty() || procList.size() < 2) {
            return Collections.emptyList();
        }
        HashMap<Integer, Pair<Long, Long>> cpuMap = new HashMap<Integer, Pair<Long, Long>>();
        for (Perfstat.perfstat_process_t stat : perfstat) {
            cpuMap.put((int)stat.pid, Pair.of((long)stat.ucpu_time, (long)stat.scpu_time));
        }
        procList.remove(0);
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (String proc : procList) {
            String[] split = RegEx.SPACES.split(proc.trim(), 16);
            if (split.length != 16) continue;
            procs.add(new AixOSProcess(pid < 0 ? Builder.parseIntOrDefault(split[1], 0) : pid, split, cpuMap, this.procCpu));
        }
        return procs;
    }

    @Override
    public int getProcessId() {
        return AixLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return this.procCpu.get().length;
    }

    @Override
    public int getThreadCount() {
        long tc = 0L;
        for (Perfstat.perfstat_process_t proc : this.procCpu.get()) {
            tc += proc.num_threads;
        }
        return (int)tc;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new AixNetworkParams();
    }

    @Override
    public OSService[] getServices() {
        File[] listFiles;
        File dir;
        ArrayList<OSService> services = new ArrayList<OSService>();
        List<String> systemServicesInfoList = Executor.runNative("lssrc -a");
        if (systemServicesInfoList.size() > 1) {
            systemServicesInfoList.remove(0);
            for (String systemService : systemServicesInfoList) {
                String[] serviceSplit = RegEx.SPACES.split(systemService.trim());
                if (systemService.contains("active")) {
                    if (serviceSplit.length == 4) {
                        services.add(new OSService(serviceSplit[0], Builder.parseIntOrDefault(serviceSplit[2], 0), OSService.State.RUNNING));
                        continue;
                    }
                    if (serviceSplit.length != 3) continue;
                    services.add(new OSService(serviceSplit[0], Builder.parseIntOrDefault(serviceSplit[1], 0), OSService.State.RUNNING));
                    continue;
                }
                if (!systemService.contains("inoperative")) continue;
                services.add(new OSService(serviceSplit[0], 0, OSService.State.STOPPED));
            }
        }
        if ((dir = new File("/etc/rc.d/init.d")).exists() && dir.isDirectory() && null != (listFiles = dir.listFiles())) {
            for (File file : listFiles) {
                String installedService = Executor.getFirstAnswer(file.getAbsolutePath() + " status");
                if (installedService.contains("running")) {
                    services.add(new OSService(file.getName(), Builder.parseLastInt(installedService, 0), OSService.State.RUNNING));
                    continue;
                }
                services.add(new OSService(file.getName(), 0, OSService.State.STOPPED));
            }
        }
        return services.toArray(new OSService[0]);
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = AixOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }
}

