/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.software;

import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.linux.software.LinuxOSFileStore;
import org.aoju.bus.health.unix.freebsd.BsdSysctlKit;

@ThreadSafe
public final class FreeBsdFileSystem
extends AbstractFileSystem {
    public static final String OSHI_FREEBSD_FS_PATH_EXCLUDES = "health.os.freebsd.filesystem.path.excludes";
    public static final String OSHI_FREEBSD_FS_PATH_INCLUDES = "health.os.freebsd.filesystem.path.includes";
    public static final String OSHI_FREEBSD_FS_VOLUME_EXCLUDES = "health.os.freebsd.filesystem.volume.excludes";
    public static final String OSHI_FREEBSD_FS_VOLUME_INCLUDES = "health.os.freebsd.filesystem.volume.includes";
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/system", "/tmp", "/dev/fd");
    private static final List<PathMatcher> FS_PATH_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.freebsd.filesystem.path.excludes");
    private static final List<PathMatcher> FS_PATH_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.freebsd.filesystem.path.includes");
    private static final List<PathMatcher> FS_VOLUME_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.freebsd.filesystem.volume.excludes");
    private static final List<PathMatcher> FS_VOLUME_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.freebsd.filesystem.volume.includes");

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        String[] split;
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        String device = "";
        for (String line : Executor.runNative("geom part list")) {
            if (line.contains("Name: ")) {
                device = line.substring(line.lastIndexOf(32) + 1);
            }
            if (device.isEmpty() || !(line = line.trim()).startsWith("rawuuid:")) continue;
            uuidMap.put(device, line.substring(line.lastIndexOf(32) + 1));
            device = "";
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        for (String line : Executor.runNative("df -i")) {
            if (!line.startsWith("/") || (split = RegEx.SPACES.split(line)).length <= 7) continue;
            inodeFreeMap.put(split[0], Builder.parseLongOrDefault(split[6], 0L));
            inodeTotalMap.put(split[0], (Long)inodeFreeMap.get(split[0]) + Builder.parseLongOrDefault(split[5], 0L));
        }
        for (String fs : Executor.runNative("mount -p")) {
            split = RegEx.SPACES.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            String options = split[3];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || Builder.filePathStartsWith(TMP_FS_PATHS, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            String uuid = uuidMap.getOrDefault(name, "");
            fsList.add(new LinuxOSFileStore(name, volume, name, path, options, uuid, "", description, type, freeSpace, usableSpace, totalSpace, inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L, inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L));
        }
        return fsList;
    }

    @Override
    public long getOpenFileDescriptors() {
        return BsdSysctlKit.sysctl("kern.openfiles", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return BsdSysctlKit.sysctl("kern.maxfiles", 0);
    }
}

