/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.unix.solaris.drivers.SystemPages;
import org.aoju.bus.health.unix.solaris.hardware.SolarisVirtualMemory;

@ThreadSafe
final class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Pair<Long, Long>> availTotal = Memoize.memoize(SystemPages::queryAvailableTotal, Memoize.defaultExpiration());
    private final Supplier<Long> pageSize = Memoize.memoize(SolarisGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    SolarisGlobalMemory() {
    }

    private static long queryPageSize() {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer("pagesize"), 4096L);
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getLeft() * this.getPageSize();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getRight() * this.getPageSize();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new SolarisVirtualMemory(this);
    }
}

