/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.PdhUtil;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.annotation.GuardeBy;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.windows.PerfCounterQueryHandler;
import org.aoju.bus.health.windows.PerfDataKit;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.WmiQueryHandler;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class PerfCounterQuery {
    public static final String TOTAL_INSTANCE = "_Total";
    public static final String TOTAL_INSTANCES = "*_Total";
    public static final String NOT_TOTAL_INSTANCE = "^_Total";
    public static final String NOT_TOTAL_INSTANCES = "^*_Total";
    @GuardeBy(value="failedQueryCacheLock")
    private static final Set<String> failedQueryCache = new HashSet<String>();
    private static final ReentrantLock failedQueryCacheLock = new ReentrantLock();

    private PerfCounterQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Enum<T>> Map<T, Long> queryValues(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        if (!failedQueryCache.contains(perfObject)) {
            failedQueryCacheLock.lock();
            try {
                if (!failedQueryCache.contains(perfObject)) {
                    Map<T, Long> valueMap = PerfCounterQuery.queryValuesFromPDH(propertyEnum, perfObject);
                    if (!valueMap.isEmpty()) {
                        Map<T, Long> map = valueMap;
                        return map;
                    }
                    Logger.warn("Disabling further attempts to query {}.", perfObject);
                    failedQueryCache.add(perfObject);
                }
            }
            finally {
                failedQueryCacheLock.unlock();
            }
        }
        return PerfCounterQuery.queryValuesFromWMI(propertyEnum, perfWmiClass);
    }

    public static <T extends Enum<T>> Map<T, Long> queryValuesFromPDH(Class<T> propertyEnum, String perfObject) {
        Enum[] props = (Enum[])propertyEnum.getEnumConstants();
        String perfObjectLocalized = PerfCounterQuery.localize(perfObject);
        EnumMap<T, PerfDataKit.PerfCounter> counterMap = new EnumMap<T, PerfDataKit.PerfCounter>(propertyEnum);
        EnumMap<T, Long> valueMap = new EnumMap<T, Long>(propertyEnum);
        try (PerfCounterQueryHandler pdhQueryHandler = new PerfCounterQueryHandler();){
            for (Enum prop : props) {
                PerfDataKit.PerfCounter counter = PerfDataKit.createCounter(perfObjectLocalized, ((PdhCounterProperty)((Object)prop)).getInstance(), ((PdhCounterProperty)((Object)prop)).getCounter());
                counterMap.put(prop, counter);
                if (pdhQueryHandler.addCounterToQuery(counter)) continue;
                EnumMap<T, Long> enumMap = valueMap;
                return enumMap;
            }
            if (0L < pdhQueryHandler.updateQuery()) {
                for (Enum prop : props) {
                    valueMap.put(prop, pdhQueryHandler.queryCounter((PerfDataKit.PerfCounter)counterMap.get(prop)));
                }
            }
        }
        return valueMap;
    }

    public static <T extends Enum<T>> Map<T, Long> queryValuesFromWMI(Class<T> propertyEnum, String wmiClass) {
        WbemcliUtil.WmiQuery query = new WbemcliUtil.WmiQuery(wmiClass, propertyEnum);
        WbemcliUtil.WmiResult result = WmiQueryHandler.createInstance().queryWMI(query);
        EnumMap<T, Long> valueMap = new EnumMap<T, Long>(propertyEnum);
        if (result.getResultCount() > 0) {
            block6: for (Enum prop : (Enum[])propertyEnum.getEnumConstants()) {
                switch (result.getCIMType(prop)) {
                    case 18: {
                        valueMap.put(prop, Long.valueOf(WmiKit.getUint16(result, prop, 0)));
                        continue block6;
                    }
                    case 19: {
                        valueMap.put(prop, WmiKit.getUint32asLong(result, prop, 0));
                        continue block6;
                    }
                    case 21: {
                        valueMap.put(prop, WmiKit.getUint64(result, prop, 0));
                        continue block6;
                    }
                    case 101: {
                        valueMap.put(prop, WmiKit.getDateTime(result, prop, 0).toInstant().toEpochMilli());
                        continue block6;
                    }
                    default: {
                        throw new ClassCastException("Unimplemented CIM Type Mapping.");
                    }
                }
            }
        }
        return valueMap;
    }

    public static String localize(String perfObject) {
        String localized = perfObject;
        try {
            localized = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)perfObject));
        }
        catch (Win32Exception e) {
            Logger.warn("Unable to locate English counter names in registry Perflib 009. Assuming English counters. Error {}. {}", String.format("0x%x", e.getHR().intValue()), "See https://support.microsoft.com/en-us/help/300956/how-to-manually-rebuild-performance-counter-library-values");
        }
        catch (PdhUtil.PdhException e) {
            Logger.warn("Unable to localize {} performance counter.  Error {}.", perfObject, String.format("0x%x", e.getErrorCode()));
        }
        if (localized.isEmpty()) {
            return perfObject;
        }
        Logger.debug("Localized {} to {}", perfObject, localized);
        return localized;
    }

    public static interface PdhCounterProperty {
        public String getInstance();

        public String getCounter();
    }
}

