/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.annotation.NotThreadSafe;
import org.aoju.bus.health.Formats;
import org.aoju.bus.health.windows.PerfDataKit;
import org.aoju.bus.logger.Logger;

@NotThreadSafe
public final class PerfCounterQueryHandler
implements AutoCloseable {
    private final Map<PerfDataKit.PerfCounter, WinNT.HANDLEByReference> counterHandleMap = new HashMap<PerfDataKit.PerfCounter, WinNT.HANDLEByReference>();
    private WinNT.HANDLEByReference queryHandle = null;

    public boolean addCounterToQuery(PerfDataKit.PerfCounter counter) {
        if (null == this.queryHandle) {
            this.queryHandle = new WinNT.HANDLEByReference();
            if (!PerfDataKit.openQuery(this.queryHandle)) {
                Logger.warn("Failed to open a query for PDH object: {}", counter.getObject());
                this.queryHandle = null;
                return false;
            }
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        if (!PerfDataKit.addCounter(this.queryHandle, counter.getCounterPath(), p)) {
            Logger.warn("Failed to add counter for PDH object: {}", counter.getObject());
            return false;
        }
        this.counterHandleMap.put(counter, p);
        return true;
    }

    public boolean removeCounterFromQuery(PerfDataKit.PerfCounter counter) {
        boolean success = false;
        WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
        if (null != href) {
            success = PerfDataKit.removeCounter(href);
        }
        if (this.counterHandleMap.isEmpty()) {
            PerfDataKit.closeQuery(this.queryHandle);
            this.queryHandle = null;
        }
        return success;
    }

    public void removeAllCounters() {
        for (WinNT.HANDLEByReference href : this.counterHandleMap.values()) {
            PerfDataKit.removeCounter(href);
        }
        this.counterHandleMap.clear();
        if (null != this.queryHandle) {
            PerfDataKit.closeQuery(this.queryHandle);
        }
        this.queryHandle = null;
    }

    public long updateQuery() {
        if (null == this.queryHandle) {
            Logger.warn("Query does not exist to update.", new Object[0]);
            return 0L;
        }
        return PerfDataKit.updateQueryTimestamp(this.queryHandle);
    }

    public long queryCounter(PerfDataKit.PerfCounter counter) {
        if (!this.counterHandleMap.containsKey(counter)) {
            if (Logger.get().isWarn()) {
                Logger.warn("Counter {} does not exist to query.", counter.getCounterPath());
            }
            return 0L;
        }
        long value = PerfDataKit.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            if (Logger.get().isWarn()) {
                Logger.warn("Error querying counter {}: {}", counter.getCounterPath(), String.format(Formats.formatError((int)value), new Object[0]));
            }
            return 0L;
        }
        return value;
    }

    @Override
    public void close() {
        this.removeAllCounters();
    }
}

