/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Cfgmgr32Util;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractUsbDevice;
import org.aoju.bus.health.builtin.hardware.UsbDevice;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.Win32DiskDrive;
import org.aoju.bus.health.windows.drivers.Win32PnPEntity;
import org.aoju.bus.health.windows.drivers.Win32USBController;
import org.aoju.bus.logger.Logger;

@Immutable
public class WindowsUsbDevice
extends AbstractUsbDevice {
    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, List<UsbDevice> connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, uniqueDeviceId, connectedDevices);
    }

    public static List<UsbDevice> getUsbDevices(boolean tree) {
        List<UsbDevice> devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList;
    }

    private static List<UsbDevice> getUsbDevices() {
        HashMap<String, List<String>> deviceTreeMap = new HashMap<String, List<String>>();
        HashSet<String> devicesSeen = new HashSet<String>();
        ArrayList<UsbDevice> controllerDevices = new ArrayList<UsbDevice>();
        List<String> controllerDeviceIdList = WindowsUsbDevice.getControllerDeviceIdList();
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0, deviceTreeMap, devicesSeen);
        }
        Map<String, Triple<String, String, String>> deviceStringMap = WindowsUsbDevice.queryDeviceStringsMap(devicesSeen);
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000", deviceTreeMap, deviceStringMap);
            if (null == deviceAndChildren) continue;
            controllerDevices.add(deviceAndChildren);
        }
        return controllerDevices;
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, List<UsbDevice> list) {
        for (UsbDevice device : list) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), Collections.emptyList()));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static Map<String, Triple<String, String, String>> queryDeviceStringsMap(Set<String> devicesToAdd) {
        HashMap<String, Triple<String, String, String>> deviceStringCache = new HashMap<String, Triple<String, String, String>>();
        if (!devicesToAdd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            HashMap<String, String> pnpToSerialMap = new HashMap<String, String>();
            WbemcliUtil.WmiResult<Win32DiskDrive.DeviceIdProperty> serialNumbers = Win32DiskDrive.queryDiskDriveId(whereClause);
            for (int i = 0; i < serialNumbers.getResultCount(); ++i) {
                String pnpDeviceID = WmiKit.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.PNPDEVICEID, i);
                pnpToSerialMap.put(pnpDeviceID, Builder.hexStringToString(WmiKit.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.SERIALNUMBER, i)));
            }
            WbemcliUtil.WmiResult<Win32PnPEntity.PnPEntityProperty> pnpEntity = Win32PnPEntity.queryDeviceId(whereClause);
            for (int i = 0; i < pnpEntity.getResultCount(); ++i) {
                String pnpDeviceID = WmiKit.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.PNPDEVICEID, i);
                String name = WmiKit.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.NAME, i);
                String vendor = WmiKit.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.MANUFACTURER, i);
                deviceStringCache.put(pnpDeviceID, Triple.of(name, vendor, pnpToSerialMap.getOrDefault(pnpDeviceID, "")));
                Logger.debug("Adding {} to USB device cache.", pnpDeviceID);
            }
        }
        return deviceStringCache;
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance, Map<String, List<String>> deviceTreeMap, Set<String> devicesSeen) {
        IntByReference child;
        devicesSeen.add(deviceId);
        int devInst = deviceInstance;
        if (devInst == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID((int)child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue(), deviceTreeMap, devicesSeen);
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID((int)sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue(), deviceTreeMap, devicesSeen);
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid, Map<String, List<String>> deviceTreeMap, Map<String, Triple<String, String, String>> deviceStringMap) {
        String vendorId = vid;
        String productId = pid;
        Pair<String, String> idPair = Builder.parsePnPDeviceIdToVendorProductId(hubDeviceId);
        if (null != idPair) {
            vendorId = idPair.getLeft();
            productId = idPair.getRight();
        }
        List pnpDeviceIds = deviceTreeMap.getOrDefault(hubDeviceId, new ArrayList());
        ArrayList<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId, deviceTreeMap, deviceStringMap);
            if (null == deviceAndChildren) continue;
            usbDevices.add(deviceAndChildren);
        }
        Collections.sort(usbDevices);
        if (deviceStringMap.containsKey(hubDeviceId)) {
            Triple<String, String, String> device = deviceStringMap.get(hubDeviceId);
            String name = device.getLeft();
            if (name.isEmpty()) {
                name = vendorId + ":" + productId;
            }
            return new WindowsUsbDevice(name, device.getMiddle(), vendorId, productId, device.getRight(), hubDeviceId, usbDevices);
        }
        return null;
    }

    private static List<String> getControllerDeviceIdList() {
        ArrayList<String> controllerDeviceIdsList = new ArrayList<String>();
        WbemcliUtil.WmiResult<Win32USBController.USBControllerProperty> usbController = Win32USBController.queryUSBControllers();
        for (int i = 0; i < usbController.getResultCount(); ++i) {
            controllerDeviceIdsList.add(WmiKit.getString(usbController, Win32USBController.USBControllerProperty.PNPDEVICEID, i));
        }
        return controllerDeviceIdsList;
    }
}

