/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.software;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.W32ServiceManager;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractOperatingSystem;
import org.aoju.bus.health.builtin.software.FileSystem;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.builtin.software.NetworkParams;
import org.aoju.bus.health.builtin.software.OSDesktopWindow;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSService;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.windows.EnumWindows;
import org.aoju.bus.health.windows.WinNT;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.HkeyUserData;
import org.aoju.bus.health.windows.drivers.NetSessionData;
import org.aoju.bus.health.windows.drivers.ProcessPerformanceData;
import org.aoju.bus.health.windows.drivers.ProcessWtsData;
import org.aoju.bus.health.windows.drivers.SessionWtsData;
import org.aoju.bus.health.windows.drivers.Win32OperatingSystem;
import org.aoju.bus.health.windows.drivers.Win32Processor;
import org.aoju.bus.health.windows.software.WindowsFileSystem;
import org.aoju.bus.health.windows.software.WindowsInternetProtocolStats;
import org.aoju.bus.health.windows.software.WindowsNetworkParams;
import org.aoju.bus.health.windows.software.WindowsOSProcess;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final String WIN_VERSION_PROPERTIES = "oshi.windows.versions.properties";
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final int TOKENELEVATION = 20;
    private static Supplier<String> systemLog = Memoize.memoize(WindowsOperatingSystem::querySystemLog, TimeUnit.HOURS.toNanos(1L));
    private static final long BOOTTIME = WindowsOperatingSystem.querySystemBootTime();
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromRegistry = Memoize.memoize(WindowsOperatingSystem::queryProcessMapFromRegistry, Memoize.defaultExpiration());
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromPerfCounters = Memoize.memoize(WindowsOperatingSystem::queryProcessMapFromPerfCounters, Memoize.defaultExpiration());

    private static Map<Integer, Integer> getParentPidsFromSnapshot() {
        HashMap<Integer, Integer> parentPidMap = new HashMap<Integer, Integer>();
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                parentPidMap.put(processEntry.th32ProcessID.intValue(), processEntry.th32ParentProcessID.intValue());
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(snapshot);
        }
        return parentPidMap;
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new WindowsInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        List<OSSession> whoList = HkeyUserData.queryUserSessions();
        whoList.addAll(SessionWtsData.queryUserSessions());
        whoList.addAll(NetSessionData.queryUserSessions());
        return whoList;
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        return this.processMapToList(pids);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.processMapToList(null);
    }

    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        Set<Integer> descendantPids = WindowsOperatingSystem.getChildrenOrDescendants(WindowsOperatingSystem.getParentPidsFromSnapshot(), parentPid, false);
        return this.processMapToList(descendantPids);
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        Set<Integer> descendantPids = WindowsOperatingSystem.getChildrenOrDescendants(WindowsOperatingSystem.getParentPidsFromSnapshot(), parentPid, true);
        return this.processMapToList(descendantPids);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<OSProcess> procList = this.processMapToList(Arrays.asList(pid));
        return procList.isEmpty() ? null : procList.get(0);
    }

    private static String querySystemLog() {
        String systemLog = Config.get("oshi.os.windows.eventlog", "System");
        if (systemLog.isEmpty()) {
            return null;
        }
        WinNT.HANDLE h = Advapi32.INSTANCE.OpenEventLog(null, systemLog);
        if (null == h) {
            Logger.warn("Unable to open configured system Event log \"{}\". Calculating boot time from uptime.", systemLog);
            return null;
        }
        return systemLog;
    }

    @Override
    public String queryManufacturer() {
        return "Microsoft";
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    @Override
    public long getSystemUptime() {
        return WindowsOperatingSystem.querySystemUptime();
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo = Win32OperatingSystem.queryOsVersion();
        if (versionInfo.getResultCount() < 1) {
            return Pair.of("Windows", new OperatingSystem.OSVersionInfo(System.getProperty("os.version"), null, null));
        }
        int suiteMask = WmiKit.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.SUITEMASK, 0);
        String buildNumber = WmiKit.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.BUILDNUMBER, 0);
        String version = this.parseVersion(versionInfo, suiteMask, buildNumber);
        String codeName = WindowsOperatingSystem.parseCodeName(suiteMask);
        return Pair.of("Windows", new OperatingSystem.OSVersionInfo(version, codeName, buildNumber));
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetworkParams();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OSService[] getServices() {
        try (W32ServiceManager sm = new W32ServiceManager();){
            sm.open(4);
            Winsvc.ENUM_SERVICE_STATUS_PROCESS[] services = sm.enumServicesStatusExProcess(48, 3, null);
            OSService[] svcArray = new OSService[services.length];
            for (int i = 0; i < services.length; ++i) {
                OSService.State state;
                switch (services[i].ServiceStatusProcess.dwCurrentState) {
                    case 1: {
                        state = OSService.State.STOPPED;
                        break;
                    }
                    case 4: {
                        state = OSService.State.RUNNING;
                        break;
                    }
                    default: {
                        state = OSService.State.OTHER;
                    }
                }
                svcArray[i] = new OSService(services[i].lpDisplayName, services[i].ServiceStatusProcess.dwProcessId, state);
            }
            OSService[] oSServiceArray = svcArray;
            return oSServiceArray;
        }
        catch (Win32Exception ex) {
            Logger.error("Win32Exception: {}", ex.getMessage());
            return new OSService[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isElevated() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 8, hToken);
        if (!success) {
            Logger.error("OpenProcessToken failed. Error: {}", Native.getLastError());
            return false;
        }
        try {
            WinNT.TOKEN_ELEVATION elevation = new WinNT.TOKEN_ELEVATION();
            if (Advapi32.INSTANCE.GetTokenInformation(hToken.getValue(), 20, (Structure)elevation, elevation.size(), new IntByReference())) {
                boolean bl = elevation.TokenIsElevated > 0;
                return bl;
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
        }
        return false;
    }

    @Override
    public List<OSDesktopWindow> getDesktopWindows(boolean visibleOnly) {
        return EnumWindows.queryDesktopWindows(visibleOnly);
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromRegistry() {
        return ProcessPerformanceData.buildProcessMapFromRegistry(null);
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromPerfCounters() {
        return ProcessPerformanceData.buildProcessMapFromPerfCounters(null);
    }

    private static long querySystemUptime() {
        if (IS_VISTA_OR_GREATER) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    private static String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return String.join((CharSequence)",", suites);
    }

    private static long querySystemBootTime() {
        String eventLog = systemLog.get();
        if (null != eventLog) {
            try {
                Advapi32Util.EventLogIterator iter = new Advapi32Util.EventLogIterator(null, eventLog, 8);
                long event6005Time = 0L;
                while (iter.hasNext()) {
                    Advapi32Util.EventLogRecord record = iter.next();
                    if (record.getStatusCode() == 12) {
                        return record.getRecord().TimeGenerated.longValue();
                    }
                    if (record.getStatusCode() != 6005) continue;
                    if (event6005Time > 0L) {
                        return event6005Time;
                    }
                    event6005Time = record.getRecord().TimeGenerated.longValue();
                }
                if (event6005Time > 0L) {
                    return event6005Time;
                }
            }
            catch (Win32Exception e) {
                Logger.warn("Can't open event log \"{}\".", eventLog);
            }
        }
        return System.currentTimeMillis() / 1000L - WindowsOperatingSystem.querySystemUptime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
        if (!success) {
            Logger.error("OpenProcessToken failed. Error: {}", Native.getLastError());
            return false;
        }
        try {
            WinNT.LUID luid = new WinNT.LUID();
            success = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
            if (!success) {
                Logger.error("LookupPrivilegeValue failed. Error: {}", Native.getLastError());
                boolean bl = false;
                return bl;
            }
            WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
            tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
            success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
            int err = Native.getLastError();
            if (!success) {
                Logger.error("AdjustTokenPrivileges failed. Error: {}", err);
                boolean bl = false;
                return bl;
            }
            if (err == 1300) {
                Logger.debug("Debug privileges not enabled.", new Object[0]);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
        }
        return true;
    }

    private List<OSProcess> processMapToList(Collection<Integer> pids) {
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> processMap = this.processMapFromRegistry.get();
        if (null == processMap || processMap.isEmpty()) {
            processMap = null == pids ? this.processMapFromPerfCounters.get() : ProcessPerformanceData.buildProcessMapFromPerfCounters(pids);
        }
        Map<Integer, ProcessWtsData.WtsInfo> processWtsMap = ProcessWtsData.queryProcessWtsMap(pids);
        HashSet<Integer> mapKeys = new HashSet<Integer>(processWtsMap.keySet());
        mapKeys.retainAll(processMap.keySet());
        ArrayList<OSProcess> processList = new ArrayList<OSProcess>();
        for (Integer pid : mapKeys) {
            processList.add(new WindowsOSProcess(pid, this, processMap, processWtsMap));
        }
        return processList;
    }

    private String parseVersion(WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo, int suiteMask, String buildNumber) {
        String version = System.getProperty("os.version");
        String[] verSplit = WmiKit.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.VERSION, 0).split("\\D");
        int major = verSplit.length > 0 ? Builder.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? Builder.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean ntWorkstation = WmiKit.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.PRODUCTTYPE, 0) == 1;
        StringBuilder verLookup = new StringBuilder().append(major).append('.').append(minor);
        if (IS_VISTA_OR_GREATER && ntWorkstation) {
            verLookup.append(".nt");
        } else if (major == 10 && Builder.parseLongOrDefault(buildNumber, 0L) > 17762L) {
            verLookup.append(".17763+");
        } else if (major == 5 && minor == 2) {
            if (ntWorkstation && this.getBitness() == 64) {
                verLookup.append(".nt.x64");
            } else if ((suiteMask & 0x8000) != 0) {
                verLookup.append(".HS");
            } else if (User32.INSTANCE.GetSystemMetrics(89) != 0) {
                verLookup.append(".R2");
            }
        }
        Properties verProps = Builder.readProperties(WIN_VERSION_PROPERTIES);
        version = null != verProps.getProperty(verLookup.toString()) ? verProps.getProperty(verLookup.toString()) : version;
        String sp = WmiKit.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.CSDVERSION, 0);
        if (!sp.isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        WbemcliUtil.WmiResult<Win32Processor.BitnessProperty> bitnessMap;
        if (jvmBitness < 64 && null != System.getenv("ProgramFiles(x86)") && IS_VISTA_OR_GREATER && (bitnessMap = Win32Processor.queryBitness()).getResultCount() > 0) {
            return WmiKit.getUint16(bitnessMap, Win32Processor.BitnessProperty.ADDRESSWIDTH, 0);
        }
        return jvmBitness;
    }

    static {
        WindowsOperatingSystem.enableDebugPrivilege();
    }
}

