/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import org.aoju.bus.core.io.BufferSink;
import org.aoju.bus.core.io.Timeout;
import org.aoju.bus.core.lang.MimeType;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.bodys.RequestBody;

public abstract class OutputStreamBody
extends RequestBody {
    boolean closed;
    private Timeout timeout;
    private long expectedContentLength;
    private OutputStream outputStream;

    protected void initOutputStream(final BufferSink sink, final long expectedContentLength) {
        this.timeout = sink.timeout();
        this.expectedContentLength = expectedContentLength;
        this.outputStream = new OutputStream(){
            private long bytesReceived;

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] source, int offset, int byteCount) throws IOException {
                if (OutputStreamBody.this.closed) {
                    throw new IOException("closed");
                }
                if (expectedContentLength != -1L && this.bytesReceived + (long)byteCount > expectedContentLength) {
                    throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived + byteCount);
                }
                this.bytesReceived += (long)byteCount;
                try {
                    sink.write(source, offset, byteCount);
                }
                catch (InterruptedIOException e) {
                    throw new SocketTimeoutException(e.getMessage());
                }
            }

            @Override
            public void flush() throws IOException {
                if (OutputStreamBody.this.closed) {
                    return;
                }
                sink.flush();
            }

            @Override
            public void close() throws IOException {
                OutputStreamBody.this.closed = true;
                if (expectedContentLength != -1L && this.bytesReceived < expectedContentLength) {
                    throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived);
                }
                sink.close();
            }
        };
    }

    public final OutputStream outputStream() {
        return this.outputStream;
    }

    public final Timeout timeout() {
        return this.timeout;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public long contentLength() {
        return this.expectedContentLength;
    }

    @Override
    public final MimeType contentType() {
        return null;
    }

    public Request prepareToSendRequest(Request request) throws IOException {
        return request;
    }
}

