/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Commands;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.service.AbstractService;
import org.aoju.bus.image.metric.service.BasicCEchoSCP;
import org.aoju.bus.image.metric.service.ImageService;
import org.aoju.bus.image.metric.service.ServiceHandler;
import org.aoju.bus.logger.Logger;

public class IanSCP
extends Device {
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private int status;
    private final ImageService ianSCP = new AbstractService(new String[]{"1.2.840.10008.5.1.4.33"}){

        @Override
        public void onDimse(Association as, Presentation pc, Dimse dimse, Attributes cmd, Attributes data) throws IOException {
            if (dimse != Dimse.N_CREATE_RQ) {
                throw new ImageException(529);
            }
            Attributes rsp = Commands.mkNCreateRSP(cmd, IanSCP.this.status);
            Attributes rspAttrs = IanSCP.this.create(as, cmd, data);
            as.tryWriteDimseRSP(pc, rsp, rspAttrs);
        }
    };

    public IanSCP() {
        super("ianscp");
        this.addConnection(this.conn);
        this.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.addService(new BasicCEchoSCP());
        serviceHandler.addService(this.ianSCP);
        this.ae.setDimseRQHandler(serviceHandler);
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public void setStorageDirectory(File storageDir) {
        if (null != storageDir) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private Attributes create(Association as, Attributes rq, Attributes rqAttrs) throws ImageException {
        if (null == this.storageDir) {
            return null;
        }
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        File file = new File(this.storageDir, iuid);
        if (file.exists()) {
            throw new ImageException(273).setUID(4096, iuid);
        }
        ImageOutputStream out = null;
        Logger.info("{}: M-WRITE {}", as, file);
        try {
            out = new ImageOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation(iuid, cuid, "1.2.840.10008.1.2.1"), rqAttrs);
        }
        catch (IOException e) {
            try {
                Logger.warn(as + ": Failed to store Instance Available Notification:", e);
                throw new ImageException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                throw throwable;
            }
        }
        IoKit.close(out);
        return null;
    }
}

