/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.mapper.criteria.Criterion;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public class Criteria {
    protected List<Criterion> criteria;
    protected boolean exists;
    protected boolean notNull;
    protected String andOr;
    protected Map<String, EntityColumn> propertyMap;
    protected String likePlaceholder = "%";

    public Criteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.criteria = new ArrayList<Criterion>();
        this.propertyMap = propertyMap;
    }

    private String column(String property) {
        if (this.propertyMap.containsKey(property)) {
            return this.propertyMap.get(property).getColumn();
        }
        if (this.exists) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return null;
    }

    private String property(String property) {
        if (this.propertyMap.containsKey(property)) {
            return property;
        }
        if (this.exists) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return null;
    }

    public void addCriterion(String condition) {
        if (null == condition) {
            throw new InstrumentException("Value for condition cannot be null");
        }
        if (condition.startsWith("null")) {
            return;
        }
        this.criteria.add(new Criterion(condition));
    }

    public void addCriterion(String condition, Object value, String property) {
        if (null == value) {
            if (this.notNull) {
                throw new InstrumentException("Value for " + property + " cannot be null");
            }
            return;
        }
        if (null == property) {
            return;
        }
        this.criteria.add(new Criterion(condition, value));
    }

    public void addCriterion(String condition, Object value1, Object value2, String property) {
        if (null == value1 || null == value2) {
            if (this.notNull) {
                throw new InstrumentException("Between values for " + property + " cannot be null");
            }
            return;
        }
        if (null == property) {
            return;
        }
        this.criteria.add(new Criterion(condition, value1, value2));
    }

    public void addOrCriterion(String condition) {
        if (null == condition) {
            throw new InstrumentException("Value for condition cannot be null");
        }
        if (condition.startsWith("null")) {
            return;
        }
        this.criteria.add(new Criterion(condition, true));
    }

    public void addOrCriterion(String condition, Object value, String property) {
        if (null == value) {
            if (this.notNull) {
                throw new InstrumentException("Value for " + property + " cannot be null");
            }
            return;
        }
        if (null == property) {
            return;
        }
        this.criteria.add(new Criterion(condition, value, true));
    }

    public void addOrCriterion(String condition, Object value1, Object value2, String property) {
        if (null == value1 || null == value2) {
            if (this.notNull) {
                throw new InstrumentException("Between values for " + property + " cannot be null");
            }
            return;
        }
        if (null == property) {
            return;
        }
        this.criteria.add(new Criterion(condition, value1, value2, true));
    }

    public Criteria andIsNull(String property) {
        this.addCriterion(this.column(property) + " is null");
        return this;
    }

    public Criteria andIsNotNull(String property) {
        this.addCriterion(this.column(property) + " is not null");
        return this;
    }

    public Criteria andEqualTo(String property, Object value) {
        this.addCriterion(this.column(property) + " =", value, this.property(property));
        return this;
    }

    public Criteria andNotEqualTo(String property, Object value) {
        this.addCriterion(this.column(property) + " <>", value, this.property(property));
        return this;
    }

    public Criteria andGreaterThan(String property, Object value) {
        this.addCriterion(this.column(property) + " >", value, this.property(property));
        return this;
    }

    public Criteria andGreaterThanOrEqualTo(String property, Object value) {
        this.addCriterion(this.column(property) + " >=", value, this.property(property));
        return this;
    }

    public Criteria andLessThan(String property, Object value) {
        this.addCriterion(this.column(property) + " <", value, this.property(property));
        return this;
    }

    public Criteria andLessThanOrEqualTo(String property, Object value) {
        this.addCriterion(this.column(property) + " <=", value, this.property(property));
        return this;
    }

    public Criteria andIn(String property, Iterable values) {
        this.addCriterion(this.column(property) + " in", values, this.property(property));
        return this;
    }

    public Criteria andNotIn(String property, Iterable values) {
        this.addCriterion(this.column(property) + " not in", values, this.property(property));
        return this;
    }

    public Criteria andBetween(String property, Object value1, Object value2) {
        this.addCriterion(this.column(property) + " between", value1, value2, this.property(property));
        return this;
    }

    public Criteria andNotBetween(String property, Object value1, Object value2) {
        this.addCriterion(this.column(property) + " not between", value1, value2, this.property(property));
        return this;
    }

    private String getLikeValue(String value) {
        if (null != value && !value.contains(this.likePlaceholder)) {
            return this.likePlaceholder + value + this.likePlaceholder;
        }
        return value;
    }

    public Criteria andLike(String property, String value) {
        this.addCriterion(this.column(property) + "  like", this.getLikeValue(value), this.property(property));
        return this;
    }

    public Criteria andBeforeLike(String property, String value) {
        return this.andLike(property, this.likePlaceholder + value);
    }

    public Criteria andAfterLike(String property, String value) {
        return this.andLike(property, value + this.likePlaceholder);
    }

    public Criteria andNotLike(String property, String value) {
        this.addCriterion(this.column(property) + "  not like", this.getLikeValue(value), this.property(property));
        return this;
    }

    public Criteria andNotBeforeLike(String property, String value) {
        return this.andNotLike(property, this.likePlaceholder + value);
    }

    public Criteria andNotAfterLike(String property, String value) {
        return this.andNotLike(property, value + this.likePlaceholder);
    }

    public Criteria andCondition(String condition) {
        this.addCriterion(condition);
        return this;
    }

    public Criteria andCondition(String condition, Object value) {
        this.criteria.add(new Criterion(condition, value));
        return this;
    }

    public Criteria andEqualTo(Object param) {
        String[] properties;
        MetaObject metaObject = SystemMetaObject.forObject((Object)param);
        for (String property : properties = metaObject.getGetterNames()) {
            Object value;
            if (null == this.propertyMap.get(property) || null == (value = metaObject.getValue(property))) continue;
            this.andEqualTo(property, value);
        }
        return this;
    }

    public Criteria andAllEqualTo(Object param) {
        String[] properties;
        MetaObject metaObject = SystemMetaObject.forObject((Object)param);
        for (String property : properties = metaObject.getGetterNames()) {
            if (null == this.propertyMap.get(property)) continue;
            Object value = metaObject.getValue(property);
            if (null != value) {
                this.andEqualTo(property, value);
                continue;
            }
            this.andIsNull(property);
        }
        return this;
    }

    public Criteria orIsNull(String property) {
        this.addOrCriterion(this.column(property) + " is null");
        return this;
    }

    public Criteria orIsNotNull(String property) {
        this.addOrCriterion(this.column(property) + " is not null");
        return this;
    }

    public Criteria orEqualTo(String property, Object value) {
        this.addOrCriterion(this.column(property) + " =", value, this.property(property));
        return this;
    }

    public Criteria orNotEqualTo(String property, Object value) {
        this.addOrCriterion(this.column(property) + " <>", value, this.property(property));
        return this;
    }

    public Criteria orGreaterThan(String property, Object value) {
        this.addOrCriterion(this.column(property) + " >", value, this.property(property));
        return this;
    }

    public Criteria orGreaterThanOrEqualTo(String property, Object value) {
        this.addOrCriterion(this.column(property) + " >=", value, this.property(property));
        return this;
    }

    public Criteria orLessThan(String property, Object value) {
        this.addOrCriterion(this.column(property) + " <", value, this.property(property));
        return this;
    }

    public Criteria orLessThanOrEqualTo(String property, Object value) {
        this.addOrCriterion(this.column(property) + " <=", value, this.property(property));
        return this;
    }

    public Criteria orIn(String property, Iterable values) {
        this.addOrCriterion(this.column(property) + " in", values, this.property(property));
        return this;
    }

    public Criteria orNotIn(String property, Iterable values) {
        this.addOrCriterion(this.column(property) + " not in", values, this.property(property));
        return this;
    }

    public Criteria orBetween(String property, Object value1, Object value2) {
        this.addOrCriterion(this.column(property) + " between", value1, value2, this.property(property));
        return this;
    }

    public Criteria orNotBetween(String property, Object value1, Object value2) {
        this.addOrCriterion(this.column(property) + " not between", value1, value2, this.property(property));
        return this;
    }

    public Criteria orLike(String property, String value) {
        this.addOrCriterion(this.column(property) + "  like", this.getLikeValue(value), this.property(property));
        return this;
    }

    public Criteria orBeforeLike(String property, String value) {
        return this.orLike(property, this.likePlaceholder + value);
    }

    public Criteria orAfterLike(String property, String value) {
        return this.orLike(property, value + this.likePlaceholder);
    }

    public Criteria orNotLike(String property, String value) {
        this.addOrCriterion(this.column(property) + "  not like", this.getLikeValue(value), this.property(property));
        return this;
    }

    public Criteria orNotBeforeLike(String property, String value) {
        return this.orLike(property, this.likePlaceholder + value);
    }

    public Criteria orNotAfterLike(String property, String value) {
        return this.orLike(property, value + this.likePlaceholder);
    }

    public Criteria orCondition(String condition) {
        this.addOrCriterion(condition);
        return this;
    }

    public Criteria orCondition(String condition, Object value) {
        this.criteria.add(new Criterion(condition, value, true));
        return this;
    }

    public Criteria orEqualTo(Object param) {
        String[] properties;
        MetaObject metaObject = SystemMetaObject.forObject((Object)param);
        for (String property : properties = metaObject.getGetterNames()) {
            Object value;
            if (null == this.propertyMap.get(property) || null == (value = metaObject.getValue(property))) continue;
            this.orEqualTo(property, value);
        }
        return this;
    }

    public Criteria orAllEqualTo(Object param) {
        String[] properties;
        MetaObject metaObject = SystemMetaObject.forObject((Object)param);
        for (String property : properties = metaObject.getGetterNames()) {
            if (null == this.propertyMap.get(property)) continue;
            Object value = metaObject.getValue(property);
            if (null != value) {
                this.orEqualTo(property, value);
                continue;
            }
            this.orIsNull(property);
        }
        return this;
    }

    public List<Criterion> getAllCriteria() {
        return this.criteria;
    }

    public String getAndOr() {
        return this.andOr;
    }

    public void setAndOr(String andOr) {
        this.andOr = andOr;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public boolean isValid() {
        return this.criteria.size() > 0;
    }
}

