/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.lang.Http;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Complex;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthCache;
import org.aoju.bus.oauth.metric.OauthScope;

public abstract class AbstractProvider
implements Provider {
    public Context context;
    public Complex source;
    public ExtendCache extendCache;

    public AbstractProvider(Context context, Complex source) {
        this(context, source, OauthCache.INSTANCE);
    }

    public AbstractProvider(Context context, Complex source, ExtendCache extendCache) {
        this.context = context;
        this.source = source;
        this.extendCache = extendCache;
        if (!AbstractProvider.isSupportedAuth(context, source)) {
            throw new AuthorizedException(Builder.ErrorCode.PARAMETER_INCOMPLETE.getCode());
        }
        AbstractProvider.checkContext(context, source);
    }

    public static boolean isSupportedAuth(Context context, Complex complex) {
        boolean isSupported;
        boolean bl = isSupported = StringKit.isNotEmpty(context.getAppKey()) && StringKit.isNotEmpty(context.getAppSecret());
        if (isSupported && Registry.ALIPAY == complex) {
            isSupported = StringKit.isNotEmpty(context.getPublicKey());
        }
        if (isSupported && Registry.STACKOVERFLOW == complex) {
            isSupported = StringKit.isNotEmpty(context.getOverflowKey());
        }
        if (isSupported && Registry.WECHAT_EE == complex) {
            isSupported = StringKit.isNotEmpty(context.getAgentId());
        }
        if (isSupported && Registry.CODING == complex) {
            isSupported = StringKit.isNotEmpty(context.getCodingGroupName());
        }
        if (isSupported && Registry.XMLY == complex) {
            boolean bl2 = isSupported = StringKit.isNotEmpty(context.getDeviceId()) && null != context.getClientOsType();
            if (isSupported) {
                isSupported = context.getClientOsType() == 3 || StringKit.isNotEmpty(context.getPackId());
            }
        }
        return isSupported;
    }

    public static boolean isLocalHost(String url) {
        return StringKit.isEmpty(url) || url.contains("127.0.0.1") || url.contains("localhost");
    }

    public static byte[] sign(byte[] key, byte[] data, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthorizedException("Unsupported algorithm: " + algorithm, ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthorizedException("Invalid key: " + Arrays.toString(key), ex);
        }
    }

    public static void checkContext(Context context, Complex complex) {
        String redirectUri = context.getRedirectUri();
        if (!Http.isHttp(redirectUri) && !Http.isHttps(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.FACEBOOK == complex && !Http.isHttps(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.ALIPAY == complex && AbstractProvider.isLocalHost(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
    }

    public static void checkCode(Complex complex, Callback callback) {
        if (complex == Registry.TWITTER) {
            return;
        }
        String code = callback.getCode();
        if (complex == Registry.ALIPAY) {
            code = callback.getAuth_code();
        } else if (complex == Registry.HUAWEI) {
            code = callback.getAuthorization_code();
        }
        if (StringKit.isEmpty(code)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_CODE.getCode());
        }
    }

    public static void checkState(String state, Complex complex, ExtendCache oauthCache) {
        if (complex == Registry.TWITTER) {
            return;
        }
        if (StringKit.isEmpty(state) || ObjectKit.isEmpty(oauthCache.get(state))) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_STATUS.getCode());
        }
    }

    public static List<String> getScopes(boolean defaultScope, OauthScope.Scope ... scopes) {
        if (null == scopes || scopes.length == 0) {
            return null;
        }
        if (defaultScope) {
            return Arrays.stream(scopes).filter(OauthScope.Scope::isDefault).map(OauthScope.Scope::getScope).collect(Collectors.toList());
        }
        return Arrays.stream(scopes).map(OauthScope.Scope::getScope).collect(Collectors.toList());
    }

    @Override
    public Message login(Callback callback) {
        try {
            AbstractProvider.checkCode(this.source, callback);
            if (!this.context.isIgnoreCheckState()) {
                AbstractProvider.checkState(callback.getState(), this.source, this.extendCache);
            }
            AccToken token = this.getAccessToken(callback);
            Property user = (Property)this.getUserInfo(token);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            String errorCode = "" + Builder.ErrorCode.FAILURE.getCode();
            if (e instanceof AuthorizedException) {
                errorCode = ((AuthorizedException)e).getErrcode();
            }
            return Message.builder().errcode(errorCode).errmsg(e.getMessage()).build();
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    protected abstract AccToken getAccessToken(Callback var1);

    protected abstract Object getUserInfo(AccToken var1);

    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).build();
    }

    protected String revokeUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.revoke()).queryParam("access_token", accToken.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringKit.isEmpty(state)) {
            state = ObjectID.id();
        }
        this.extendCache.cache(state, state);
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return Httpx.post(this.accessTokenUrl(code));
    }

    public String doGetAuthorizationCode(String code) {
        return Httpx.get(this.accessTokenUrl(code));
    }

    protected String doGetUserInfo(AccToken accToken) {
        return Httpx.get(this.userInfoUrl(accToken));
    }

    protected String doGetRevoke(AccToken accToken) {
        return Httpx.get(this.revokeUrl(accToken));
    }

    protected String getScopes(String separator, boolean encode, List<String> defaultScopes) {
        List<String> scopes = this.context.getScopes();
        if (null == scopes || scopes.isEmpty()) {
            if (null == defaultScopes || defaultScopes.isEmpty()) {
                return "";
            }
            scopes = defaultScopes;
        }
        if (null == separator) {
            separator = " ";
        }
        String scopeStr = String.join((CharSequence)separator, scopes);
        return encode ? UriKit.encode(scopeStr) : scopeStr;
    }

    public Map<String, String> parseStringToMap(String str, boolean decode) {
        int i;
        if (StringKit.isNotEmpty(str)) {
            int endPos;
            int beginPos = str.indexOf("?");
            if (beginPos > -1) {
                str = str.substring(beginPos + 1);
            }
            if ((endPos = str.indexOf("#")) > -1) {
                str = str.substring(0, endPos);
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        if (StringKit.isEmpty(str)) {
            return params;
        }
        if (!str.contains("&")) {
            params.put(decode ? UriKit.decode(str) : str, "");
            return params;
        }
        int len = str.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = str.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                this.addParam(params, str.substring(pos, i), "", decode);
            } else if (null != name) {
                this.addParam(params, name, str.substring(pos, i), decode);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (null == name) {
                this.addParam(params, str.substring(pos, i), "", decode);
            } else {
                this.addParam(params, name, str.substring(pos, i), decode);
            }
        } else if (null != name) {
            this.addParam(params, name, "", decode);
        }
        return params;
    }

    private void addParam(Map<String, String> params, String key, String value, boolean decode) {
        key = decode ? UriKit.decode(key) : key;
        String string = value = decode ? UriKit.decode(value) : value;
        if (params.containsKey(key)) {
            params.put(key, params.get(key) + "," + value);
        } else {
            params.put(key, value);
        }
    }
}

