/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class DouyinProvider
extends AbstractProvider {
    public DouyinProvider(Context context) {
        super(context, Registry.DOUYIN);
    }

    public DouyinProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.DOUYIN, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject jsonObject = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(jsonObject);
        JSONObject object = jsonObject.getJSONObject("data");
        return Property.builder().rawJson(object).uuid(object.getString("union_id")).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("avatar")).remark(object.getString("description")).gender(Normal.Gender.of(object.getString("gender"))).location(String.format("%s %s %s", object.getString("country"), object.getString("province"), object.getString("city"))).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(accToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "user_info").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("open_id", accToken.getOpenId()).build();
    }

    @Override
    public String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("client_key", this.context.getAppKey()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }

    private void checkResponse(JSONObject object) {
        String message = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        int errorCode = data.getIntValue("error_code");
        if ("error".equals(message) || errorCode != 0) {
            throw new AuthorizedException("" + errorCode, data.getString("description"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)Httpx.post(accessTokenUrl));
        this.checkResponse(object);
        JSONObject dataObj = object.getJSONObject("data");
        return AccToken.builder().accessToken(dataObj.getString("access_token")).openId(dataObj.getString("open_id")).expireIn(dataObj.getIntValue("expires_in")).refreshToken(dataObj.getString("refresh_token")).scope(dataObj.getString("scope")).build();
    }
}

