/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class TeambitionProvider
extends AbstractProvider {
    public TeambitionProvider(Context context) {
        super(context, Registry.TEAMBITION);
    }

    public TeambitionProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.TEAMBITION, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        params.put("code", callback.getCode());
        params.put("grant_type", "code");
        String response = Httpx.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "OAuth2 " + accToken.getAccessToken());
        String response = Httpx.post(this.source.userInfo(), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        accToken.setUid(object.getString("_id"));
        return Property.builder().rawJson(object).uuid(object.getString("_id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatarUrl")).blog(object.getString("website")).location(object.getString("location")).email(object.getString("email")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("_userId", accToken.getUid());
        params.put("refresh_token", accToken.getRefreshToken());
        String response = Httpx.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"message") && object.containsKey((Object)"name")) {
            throw new AuthorizedException(object.getString("name") + ", " + object.getString("message"));
        }
    }
}

