/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.BufferFactory;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.TcpAioSession;
import org.aoju.bus.socket.handler.CompletionReadHandler;
import org.aoju.bus.socket.handler.CompletionWriteHandler;
import org.aoju.bus.socket.process.MessageProcessor;

public class AioQuickClient<T> {
    private final ServerConfig<T> config = new ServerConfig();
    private TcpAioSession<T> session;
    private ByteBuffer bufferPool = null;
    private ByteBuffer innerBufferPool = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;
    private int connectTimeout;
    private final BufferFactory.VirtualBufferFactory readBufferFactory = bufferPage -> bufferPage.allocate(this.config.getReadBufferSize());

    public AioQuickClient(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public AioSession start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        CompletableFuture<AioSession> future = this.asyncStart(asynchronousChannelGroup);
        try {
            if (this.connectTimeout > 0) {
                future.get(this.connectTimeout, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (Exception e) {
            this.shutdownNow();
            throw new IOException(e);
        }
        return this.session;
    }

    public CompletableFuture<AioSession> asyncStart(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        Objects.requireNonNull(asynchronousChannelGroup);
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (null == this.bufferPool) {
            this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
        }
        if (null != this.config.getSocketOptions()) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        if (null != this.localAddress) {
            socketChannel.bind(this.localAddress);
        }
        final CompletableFuture<AioSession> completableFuture = new CompletableFuture<AioSession>();
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){

            @Override
            public void completed(Void result, AsynchronousSocketChannel socketChannel) {
                AsynchronousSocketChannel connectedChannel = socketChannel;
                if (null != AioQuickClient.this.config.getMonitor()) {
                    connectedChannel = AioQuickClient.this.config.getMonitor().shouldAccept(socketChannel);
                }
                if (null == connectedChannel) {
                    throw new RuntimeException("NetMonitor refuse channel");
                }
                AioQuickClient.this.session = new TcpAioSession(connectedChannel, AioQuickClient.this.config, new CompletionReadHandler(), new CompletionWriteHandler(), AioQuickClient.this.bufferPool.allocatePageBuffer());
                AioQuickClient.this.session.initSession(AioQuickClient.this.readBufferFactory.newBuffer(AioQuickClient.this.bufferPool.allocatePageBuffer()));
                completableFuture.complete(AioQuickClient.this.session);
            }

            @Override
            public void failed(Throwable exc, AsynchronousSocketChannel socketChannel) {
                completableFuture.completeExceptionally(exc);
            }
        });
        return completableFuture;
    }

    public final AioSession start() throws IOException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, Thread::new);
        return this.start(this.asynchronousChannelGroup);
    }

    public final void shutdown() {
        this.showdown0(false);
    }

    public final void shutdownNow() {
        this.showdown0(true);
    }

    private void showdown0(boolean flag) {
        if (null != this.session) {
            this.session.close(flag);
            this.session = null;
        }
        if (null != this.asynchronousChannelGroup) {
            this.asynchronousChannelGroup.shutdown();
        }
        if (null != this.innerBufferPool) {
            this.innerBufferPool.release();
        }
    }

    public final AioQuickClient<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final <V> AioQuickClient<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickClient<T> bindLocal(String local, int port) {
        this.localAddress = null == local ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public final AioQuickClient<T> setPageBufferPool(ByteBuffer bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final AioQuickClient<T> setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }

    public final AioQuickClient<T> setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final AioQuickClient<T> connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }
}

