/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.handler;

import java.nio.channels.CompletionHandler;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.TcpAioSession;

public class CompletionReadHandler<T>
implements CompletionHandler<Integer, TcpAioSession<T>> {
    @Override
    public void completed(Integer result, TcpAioSession<T> aioSession) {
        try {
            NetMonitor monitor = aioSession.getServerConfig().getMonitor();
            if (null != monitor) {
                monitor.afterRead(aioSession, result);
            }
            aioSession.flipRead(result == -1);
            aioSession.signalRead();
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public final void failed(Throwable exc, TcpAioSession<T> aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, SocketStatus.INPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            aioSession.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
    }
}

