/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDescription;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.beans.copier.provider.BeanValueProvider;
import org.aoju.bus.core.beans.copier.provider.MapValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Typed;
import org.aoju.bus.core.lang.copier.Copier;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class BeanCopier<T>
implements Copier<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object source;
    private final T dest;
    private final Type destType;
    private final CopyOptions copyOptions;

    public BeanCopier(Object source, T dest, Type destType, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.destType = destType;
        this.copyOptions = copyOptions;
    }

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return BeanCopier.create(source, dest, dest.getClass(), copyOptions);
    }

    public static <T> BeanCopier<T> create(Object source, T dest, Type destType, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, destType, copyOptions);
    }

    private static String mappingKey(Map<String, String> mapping, String fieldName) {
        if (MapKit.isEmpty(mapping)) {
            return fieldName;
        }
        return ObjectKit.defaultIfNull(mapping.get(fieldName), fieldName);
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof Map) {
                if (this.dest instanceof Map) {
                    this.mapToMap((Map)this.source, (Map)this.dest);
                } else {
                    this.mapToBean((Map)this.source, this.dest);
                }
            } else if (this.dest instanceof Map) {
                this.beanToMap(this.source, (Map)this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), bean);
    }

    private void mapToMap(Map source, Map dest) {
        if (null != dest && null != source) {
            dest.putAll(source);
        }
    }

    private void beanToMap(Object bean, Map targetMap) {
        Collection<PropertyDescription> props = BeanKit.getBeanDesc(bean.getClass()).getProps();
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollKit.newHashSet(this.copyOptions.ignoreProperties) : null;
        CopyOptions copyOptions = this.copyOptions;
        for (PropertyDescription prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new InstrumentException("Get value of [{}] error!", prop.getFieldName());
            }
            if (CollKit.contains(ignoreSet, (Object)key) || null != copyOptions.propertiesFilter && !copyOptions.propertiesFilter.test(prop.getField(), value) || null == value && copyOptions.ignoreNullValue || bean.equals(value)) continue;
            targetMap.put(BeanCopier.mappingKey(copyOptions.fieldMapping, key), value);
        }
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = bean.getClass();
        if (null != copyOptions.editable) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StringKit.format("Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != copyOptions.ignoreProperties ? CollKit.newHashSet(copyOptions.ignoreProperties) : null;
        Map<String, String> fieldReverseMapping = copyOptions.getReversedMapping();
        Collection<PropertyDescription> props = BeanKit.getBeanDesc(actualEditable).getProps();
        for (PropertyDescription prop : props) {
            Type valueType;
            Method setterMethod;
            String providerKey;
            Field field = prop.getField();
            String fieldName = prop.getFieldName();
            if (CollKit.contains(ignoreSet, (Object)fieldName) || !valueProvider.containsKey(providerKey = BeanCopier.mappingKey(fieldReverseMapping, fieldName)) || null == (setterMethod = prop.getSetter()) && !BeanKit.isPublic(field)) continue;
            Type type = valueType = null == setterMethod ? TypeKit.getType(field) : TypeKit.getFirstParamType(setterMethod);
            if (valueType instanceof ParameterizedType) {
                ParameterizedType tmp = (ParameterizedType)valueType;
                Type[] actualTypeArguments = tmp.getActualTypeArguments();
                if (TypeKit.hasTypeVeriable(actualTypeArguments) && ArrayKit.isNotEmpty(actualTypeArguments = TypeKit.getActualTypes(this.destType, field.getDeclaringClass(), tmp.getActualTypeArguments()))) {
                    valueType = new Typed(actualTypeArguments, tmp.getOwnerType(), tmp.getRawType());
                }
            } else if (valueType instanceof TypeVariable) {
                valueType = TypeKit.getActualType(this.destType, field.getDeclaringClass(), valueType);
            }
            Object value = valueProvider.value(providerKey, valueType);
            if (null == value && copyOptions.ignoreNullValue || bean == value) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convertWithCheck(propClass, value, null, copyOptions.ignoreError)) && copyOptions.ignoreNullValue) continue;
                prop.setValue(bean, value);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new InstrumentException("Inject [{}] error!", prop.getFieldName());
            }
        }
    }
}

