/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier.provider;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDescription;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BeanValueProvider
implements ValueProvider<String> {
    final Map<String, PropertyDescription> sourcePdMap;
    private final Object source;
    private final boolean ignoreError;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this.source = bean;
        this.ignoreError = ignoreError;
        this.sourcePdMap = BeanKit.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
    }

    @Override
    public Object value(String key, Type valueType) {
        Method getter;
        PropertyDescription sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StringKit.upperFirstAndAddPre(key, "is"));
        }
        Object result = null;
        if (null != sourcePd && null != (getter = sourcePd.getGetter())) {
            block5: {
                try {
                    result = getter.invoke(this.source, new Object[0]);
                }
                catch (Exception e) {
                    if (this.ignoreError) break block5;
                    throw new InstrumentException("Inject [{}] error!", key);
                }
            }
            Object convertValue = Convert.convertWithCheck(valueType, result, null, this.ignoreError);
            if (null != convertValue) {
                result = convertValue;
            }
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.sourcePdMap.containsKey(key) || this.sourcePdMap.containsKey(StringKit.upperFirstAndAddPre(key, "is"));
    }
}

