/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier.provider;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.StringKit;

public class MapValueProvider
implements ValueProvider<String> {
    private final Map<?, ?> map;
    private final boolean ignoreError;

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase) {
        this(map, ignoreCase, false);
    }

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase, boolean ignoreError) {
        this.map = false == ignoreCase || map instanceof CaseInsensitiveMap ? map : new CaseInsensitiveMap(map);
        this.ignoreError = ignoreError;
    }

    @Override
    public Object value(String key, Type valueType) {
        String key1 = this.getKey(key, valueType);
        if (null == key1) {
            return null;
        }
        Object value = this.map.get(key1);
        return Convert.convertWithCheck(valueType, value, null, this.ignoreError);
    }

    @Override
    public boolean containsKey(String key) {
        return null != this.getKey(key, null);
    }

    private String getKey(String key, Type valueType) {
        if (this.map.containsKey(key)) {
            return key;
        }
        String customKey = StringKit.toUnderlineCase(key);
        if (this.map.containsKey(customKey)) {
            return customKey;
        }
        if (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType) {
            customKey = StringKit.upperFirstAndAddPre(key, "is");
            if (this.map.containsKey(customKey)) {
                return customKey;
            }
            if (this.map.containsKey(customKey = StringKit.toUnderlineCase(customKey))) {
                return customKey;
            }
        }
        return null;
    }
}

