/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.date.Holiday;
import org.aoju.bus.core.date.Kalendar;
import org.aoju.bus.core.date.Lunar;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class Solar {
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("1-1", "\u5143\u65e6\u8282");
            this.put("2-14", "\u60c5\u4eba\u8282");
            this.put("3-8", "\u5987\u5973\u8282");
            this.put("3-12", "\u690d\u6811\u8282");
            this.put("3-15", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
            this.put("4-1", "\u611a\u4eba\u8282");
            this.put("5-1", "\u52b3\u52a8\u8282");
            this.put("5-4", "\u9752\u5e74\u8282");
            this.put("6-1", "\u513f\u7ae5\u8282");
            this.put("7-1", "\u5efa\u515a\u8282");
            this.put("8-1", "\u5efa\u519b\u8282");
            this.put("9-10", "\u6559\u5e08\u8282");
            this.put("10-1", "\u56fd\u5e86\u8282");
            this.put("12-24", "\u5e73\u5b89\u591c");
            this.put("12-25", "\u5723\u8bde\u8282");
        }
    };
    public static final Map<String, String> WEEK_FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("5-2-0", "\u6bcd\u4eb2\u8282");
            this.put("6-3-0", "\u7236\u4eb2\u8282");
            this.put("11-4-4", "\u611f\u6069\u8282");
        }
    };
    public static final Map<String, List<String>> OTHER_FESTIVAL = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("1-8", Collections.nCopies(1, "\u5468\u6069\u6765\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-10", Arrays.asList("\u4e2d\u56fd\u4eba\u6c11\u8b66\u5bdf\u8282", "\u4e2d\u56fd\u516c\u5b89110\u5ba3\u4f20\u65e5"));
            this.put("1-21", Collections.nCopies(1, "\u5217\u5b81\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-26", Collections.nCopies(1, "\u56fd\u9645\u6d77\u5173\u65e5"));
            this.put("2-2", Collections.nCopies(1, "\u4e16\u754c\u6e7f\u5730\u65e5"));
            this.put("2-4", Collections.nCopies(1, "\u4e16\u754c\u6297\u764c\u65e5"));
            this.put("2-7", Collections.nCopies(1, "\u4eac\u6c49\u94c1\u8def\u7f62\u5de5\u7eaa\u5ff5"));
            this.put("2-10", Collections.nCopies(1, "\u56fd\u9645\u6c14\u8c61\u8282"));
            this.put("2-19", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("2-21", Collections.nCopies(1, "\u56fd\u9645\u6bcd\u8bed\u65e5"));
            this.put("2-24", Collections.nCopies(1, "\u7b2c\u4e09\u4e16\u754c\u9752\u5e74\u65e5"));
            this.put("3-1", Collections.nCopies(1, "\u56fd\u9645\u6d77\u8c79\u65e5"));
            this.put("3-3", Collections.nCopies(1, "\u5168\u56fd\u7231\u8033\u65e5"));
            this.put("3-5", Arrays.asList("\u5468\u6069\u6765\u8bde\u8fb0\u7eaa\u5ff5\u65e5", "\u4e2d\u56fd\u9752\u5e74\u5fd7\u613f\u8005\u670d\u52a1\u65e5"));
            this.put("3-6", Collections.nCopies(1, "\u4e16\u754c\u9752\u5149\u773c\u65e5"));
            this.put("3-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("3-14", Collections.nCopies(1, "\u9a6c\u514b\u601d\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("3-17", Collections.nCopies(1, "\u56fd\u9645\u822a\u6d77\u65e5"));
            this.put("3-18", Collections.nCopies(1, "\u5168\u56fd\u79d1\u6280\u4eba\u624d\u6d3b\u52a8\u65e5"));
            this.put("3-21", Arrays.asList("\u4e16\u754c\u68ee\u6797\u65e5", "\u4e16\u754c\u7761\u7720\u65e5"));
            this.put("3-22", Collections.nCopies(1, "\u4e16\u754c\u6c34\u65e5"));
            this.put("3-23", Collections.nCopies(1, "\u4e16\u754c\u6c14\u8c61\u65e5"));
            this.put("3-24", Collections.nCopies(1, "\u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5"));
            this.put("4-2", Collections.nCopies(1, "\u56fd\u9645\u513f\u7ae5\u56fe\u4e66\u65e5"));
            this.put("4-7", Collections.nCopies(1, "\u4e16\u754c\u536b\u751f\u65e5"));
            this.put("4-22", Collections.nCopies(1, "\u5217\u5b81\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("4-23", Collections.nCopies(1, "\u4e16\u754c\u56fe\u4e66\u548c\u7248\u6743\u65e5"));
            this.put("4-26", Collections.nCopies(1, "\u4e16\u754c\u77e5\u8bc6\u4ea7\u6743\u65e5"));
            this.put("5-3", Collections.nCopies(1, "\u4e16\u754c\u65b0\u95fb\u81ea\u7531\u65e5"));
            this.put("5-5", Collections.nCopies(1, "\u9a6c\u514b\u601d\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("5-8", Collections.nCopies(1, "\u4e16\u754c\u7ea2\u5341\u5b57\u65e5"));
            this.put("5-11", Collections.nCopies(1, "\u4e16\u754c\u80a5\u80d6\u65e5"));
            this.put("5-23", Collections.nCopies(1, "\u4e16\u754c\u8bfb\u4e66\u65e5"));
            this.put("5-27", Collections.nCopies(1, "\u4e0a\u6d77\u89e3\u653e\u65e5"));
            this.put("5-31", Collections.nCopies(1, "\u4e16\u754c\u65e0\u70df\u65e5"));
            this.put("6-5", Collections.nCopies(1, "\u4e16\u754c\u73af\u5883\u65e5"));
            this.put("6-6", Collections.nCopies(1, "\u5168\u56fd\u7231\u773c\u65e5"));
            this.put("6-8", Collections.nCopies(1, "\u4e16\u754c\u6d77\u6d0b\u65e5"));
            this.put("6-11", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u53e3\u65e5"));
            this.put("6-14", Collections.nCopies(1, "\u4e16\u754c\u732e\u8840\u65e5"));
            this.put("7-1", Collections.nCopies(1, "\u9999\u6e2f\u56de\u5f52\u7eaa\u5ff5\u65e5"));
            this.put("7-7", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u6c11\u6297\u65e5\u6218\u4e89\u7eaa\u5ff5\u65e5"));
            this.put("7-11", Collections.nCopies(1, "\u4e16\u754c\u4eba\u53e3\u65e5"));
            this.put("8-5", Collections.nCopies(1, "\u6069\u683c\u65af\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("8-6", Collections.nCopies(1, "\u56fd\u9645\u7535\u5f71\u8282"));
            this.put("8-12", Collections.nCopies(1, "\u56fd\u9645\u9752\u5e74\u65e5"));
            this.put("8-22", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("9-3", Collections.nCopies(1, "\u4e2d\u56fd\u6297\u65e5\u6218\u4e89\u80dc\u5229\u7eaa\u5ff5\u65e5"));
            this.put("9-8", Collections.nCopies(1, "\u4e16\u754c\u626b\u76f2\u65e5"));
            this.put("9-9", Collections.nCopies(1, "\u6bdb\u6cfd\u4e1c\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("9-14", Collections.nCopies(1, "\u4e16\u754c\u6e05\u6d01\u5730\u7403\u65e5"));
            this.put("9-18", Collections.nCopies(1, "\u4e5d\u4e00\u516b\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("9-20", Collections.nCopies(1, "\u5168\u56fd\u7231\u7259\u65e5"));
            this.put("9-21", Collections.nCopies(1, "\u56fd\u9645\u548c\u5e73\u65e5"));
            this.put("9-27", Collections.nCopies(1, "\u4e16\u754c\u65c5\u6e38\u65e5"));
            this.put("10-4", Collections.nCopies(1, "\u4e16\u754c\u52a8\u7269\u65e5"));
            this.put("10-10", Collections.nCopies(1, "\u8f9b\u4ea5\u9769\u547d\u7eaa\u5ff5\u65e5"));
            this.put("10-13", Collections.nCopies(1, "\u4e2d\u56fd\u5c11\u5e74\u5148\u950b\u961f\u8bde\u8fb0\u65e5"));
            this.put("10-25", Collections.nCopies(1, "\u6297\u7f8e\u63f4\u671d\u7eaa\u5ff5\u65e5"));
            this.put("11-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("11-17", Collections.nCopies(1, "\u56fd\u9645\u5927\u5b66\u751f\u8282"));
            this.put("11-28", Collections.nCopies(1, "\u6069\u683c\u65af\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("12-1", Collections.nCopies(1, "\u4e16\u754c\u827e\u6ecb\u75c5\u65e5"));
            this.put("12-12", Collections.nCopies(1, "\u897f\u5b89\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("12-13", Collections.nCopies(1, "\u5357\u4eac\u5927\u5c60\u6740\u7eaa\u5ff5\u65e5"));
            this.put("12-26", Collections.nCopies(1, "\u6bdb\u6cfd\u4e1c\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
        }
    };
    public static final double J2000 = 2451545.0;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final Calendar calendar;

    public Solar() {
        this(new Date());
    }

    public Solar(Date date) {
        this.calendar = Kalendar.calendar(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2) + 1;
        this.day = this.calendar.get(5);
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
        this.second = this.calendar.get(13);
    }

    public Solar(Calendar calendar) {
        calendar.set(14, 0);
        this.calendar = calendar;
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    public Solar(double julianDay) {
        int d = (int)(julianDay + 0.5);
        double f = julianDay + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 1.0 / 4.0);
        }
        int year = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int month = (int)((double)(d -= (int)(365.25 * (double)year)) * 1.0 / 30.601);
        int day = d -= (int)(30.601 * (double)month);
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.round(f *= 60.0);
        this.calendar = Kalendar.calendar(year, month, day, hour, minute, second);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public Solar(int year, int month, int day, int hour, int minute, int second) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(year, month - 1, day, hour, minute, second);
        this.calendar.set(14, 0);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public Solar(int year, int month, int day) {
        this(year, month, day, 0, 0, 0);
    }

    public static Solar from(Date date) {
        return new Solar(date);
    }

    public static Solar from(Calendar calendar) {
        return new Solar(calendar);
    }

    public static Solar from(double julianDay) {
        return new Solar(julianDay);
    }

    public static Solar from(int year, int month, int day) {
        return new Solar(year, month, day);
    }

    public static Solar from(int year, int month, int day, int hour, int minute, int second) {
        return new Solar(year, month, day, hour, minute, second);
    }

    public static List<Solar> from(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi) {
        return Solar.from(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, 2);
    }

    public static List<Solar> from(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect) {
        return Solar.fromBaZi(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, sect, 1900);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect, int baseYear) {
        sect = 1 == sect ? 1 : 2;
        Solar today = new Solar();
        Lunar lunar = today.getLunar();
        int offsetYear = Lunar.getJiaZiIndex(lunar.getYearInGanZhiExact()) - Lunar.getJiaZiIndex(yearGanZhi);
        if (offsetYear < 0) {
            offsetYear += 60;
        }
        int startYear = today.getYear() - offsetYear;
        int hour = 0;
        String timeZhi = timeGanZhi.substring(1);
        int j = Fields.CN_ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!Fields.CN_ZHI[i].equals(timeZhi)) continue;
            hour = (i - 1) * 2;
        }
        ArrayList<Solar> list = new ArrayList<Solar>();
        while (startYear >= baseYear) {
            int day;
            Solar solar;
            int counter;
            int year = startYear - 1;
            int month = 12;
            boolean found = false;
            for (counter = 0; counter < 15; ++counter) {
                if (year >= baseYear && (lunar = (solar = new Solar(year, month, day = 1, hour, 0, 0)).getLunar()).getYearInGanZhiExact().equals(yearGanZhi) && lunar.getMonthInGanZhiExact().equals(monthGanZhi)) {
                    found = true;
                    break;
                }
                if (++month <= 12) continue;
                month = 1;
                ++year;
            }
            if (found) {
                counter = 0;
                if (--month < 1) {
                    month = 12;
                    --year;
                }
                day = 1;
                solar = new Solar(year, month, day, hour, 0, 0);
                while (counter < 61) {
                    String dgz;
                    lunar = solar.getLunar();
                    String string = dgz = 2 == sect ? lunar.getDayInGanZhiExact2() : lunar.getDayInGanZhiExact();
                    if (lunar.getYearInGanZhiExact().equals(yearGanZhi) && lunar.getMonthInGanZhiExact().equals(monthGanZhi) && dgz.equals(dayGanZhi) && lunar.getTimeInGanZhi().equals(timeGanZhi)) {
                        list.add(solar);
                        break;
                    }
                    solar = solar.next(1);
                    ++counter;
                }
            }
            startYear -= 60;
        }
        return list;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDaysOfMonth(int year, int month) {
        int m = month - 1;
        int d = Fields.DAYS_OF_MONTH[m];
        if (m == 1 && Solar.isLeapYear(year)) {
            ++d;
        }
        return d;
    }

    public static int getWeeksOfMonth(int year, int month, int start) {
        int days = Solar.getDaysOfMonth(year, month);
        int week = Kalendar.calendar(year, month, 1).get(7) - 1;
        return (int)Math.ceil((double)(days + week - start) * 1.0 / 7.0);
    }

    public boolean isLeapYear() {
        return Solar.isLeapYear(this.year);
    }

    public int getWeek() {
        return this.calendar.get(7);
    }

    public String getWeekInChinese() {
        return Fields.Week.getCnNameByCode(this.getWeek());
    }

    public List<String> getFestivals() {
        ArrayList<String> list = new ArrayList<String>();
        String festival = FESTIVAL.get(this.month + "-" + this.day);
        if (null != festival) {
            list.add(festival);
        }
        int weeks = (int)Math.ceil((double)this.day / 7.0);
        int week = this.getWeek();
        festival = WEEK_FESTIVAL.get(this.month + "-" + weeks + "-" + week);
        if (null != festival) {
            list.add(festival);
        }
        return list;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> list = new ArrayList<String>();
        List<String> fs = OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            list.addAll(fs);
        }
        return list;
    }

    public String getZodiac() {
        int index = 11;
        int y = this.month * 100 + this.day;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 621) {
            index = 2;
        } else if (y >= 622 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1023) {
            index = 6;
        } else if (y >= 1024 && y <= 1122) {
            index = 7;
        } else if (y >= 1123 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return Fields.ZODIAC[index];
    }

    public double getJulianDay() {
        int y = this.year;
        int m = this.month;
        double d = (double)this.day + (((double)this.second * 1.0 / 60.0 + (double)this.minute) / 60.0 + (double)this.hour) / 24.0;
        int n = 0;
        boolean g = false;
        if (y * 372 + m * 31 + (int)d >= 588829) {
            g = true;
        }
        if (m <= 2) {
            m += 12;
            --y;
        }
        if (g) {
            n = (int)((double)y * 1.0 / 100.0);
            n = 2 - n + (int)((double)n * 1.0 / 4.0);
        }
        return (double)((int)(365.25 * (double)(y + 4716)) + (int)(30.6001 * (double)(m + 1))) + d + (double)n - 1524.5;
    }

    public Solar next(int days) {
        return this.next(days, false);
    }

    public Solar next(int days, boolean onlyWorkday) {
        Calendar calendar = Kalendar.calendar(this.year, this.month, this.day, this.hour, this.minute, this.second);
        if (0 != days) {
            if (!onlyWorkday) {
                calendar.add(5, days);
            } else {
                int add;
                int rest = Math.abs(days);
                int n = add = days < 1 ? -1 : 1;
                while (rest > 0) {
                    calendar.add(5, add);
                    boolean work = true;
                    Holiday holiday = Holiday.getHoliday(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                    if (null == holiday) {
                        int week = calendar.get(7);
                        if (1 == week || 7 == week) {
                            work = false;
                        }
                    } else {
                        work = holiday.isWork();
                    }
                    if (!work) continue;
                    --rest;
                }
            }
        }
        return new Solar(calendar);
    }

    public Lunar getLunar() {
        return new Lunar(this.calendar.getTime());
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String build(boolean ... args) {
        String strYmd = this.year + "-" + (this.month < 10 ? "0" : "") + this.month + "-" + (this.day < 10 ? "0" : "") + this.day;
        String strYmdHms = strYmd + " " + (this.hour < 10 ? "0" : "") + this.hour + ':' + (this.minute < 10 ? "0" : "") + this.minute + ':' + (this.second < 10 ? "0" : "") + this.second;
        if (ObjectKit.isNotEmpty((Object)args)) {
            if (BooleanKit.and(args)) {
                StringBuilder s = new StringBuilder();
                s.append(strYmdHms);
                if (this.isLeapYear()) {
                    s.append(" ");
                    s.append("\u95f0\u5e74");
                }
                s.append(" ");
                s.append(this.getWeekInChinese());
                for (String f : this.getFestivals()) {
                    s.append(" (");
                    s.append(f);
                    s.append(")");
                }
                for (String f : this.getOtherFestivals()) {
                    s.append(" (");
                    s.append(f);
                    s.append(")");
                }
                s.append(" ");
                s.append(this.getZodiac());
                return s.toString();
            }
            return strYmd;
        }
        return strYmdHms;
    }

    public static class Week {
        private final int year;
        private final int month;
        private final int day;
        private final int start;

        public Week(int start) {
            this(new Date(), start);
        }

        public Week(Date date, int start) {
            Calendar calendar = Kalendar.calendar(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
            this.day = calendar.get(5);
            this.start = start;
        }

        public Week(Calendar calendar, int start) {
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
            this.day = calendar.get(5);
            this.start = start;
        }

        public Week(int year, int month, int day, int start) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.start = start;
        }

        public static Week from(Date date, int start) {
            return new Week(date, start);
        }

        public static Week from(Calendar calendar, int start) {
            return new Week(calendar, start);
        }

        public static Week from(int year, int month, int day, int start) {
            return new Week(year, month, day, start);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getStart() {
            return this.start;
        }

        public int getIndex() {
            Calendar calendar = Kalendar.calendar(this.year, this.month, 1);
            int firstDayWeek = calendar.get(7) - 1;
            if (firstDayWeek == 0) {
                firstDayWeek = 7;
            }
            return (int)Math.ceil((double)(this.day + firstDayWeek - this.start) / 7.0);
        }

        public Week next(int weeks, boolean separateMonth) {
            if (0 == weeks) {
                return new Week(this.year, this.month, this.day, this.start);
            }
            if (separateMonth) {
                int n;
                boolean plus;
                Calendar c = Kalendar.calendar(this.year, this.month, this.day);
                Week week = new Week(c, this.start);
                int month = this.month;
                boolean bl = plus = n > 0;
                for (n = weeks; 0 != n; n -= plus ? 1 : -1) {
                    c.add(5, plus ? 7 : -7);
                    week = new Week(c, this.start);
                    int weekMonth = week.getMonth();
                    if (month == weekMonth) continue;
                    int index = week.getIndex();
                    if (plus) {
                        if (1 == index) {
                            Solar firstDay = week.getFirstDay();
                            week = new Week(firstDay.getYear(), firstDay.getMonth(), firstDay.getDay(), this.start);
                            weekMonth = week.getMonth();
                        } else {
                            c = Kalendar.calendar(week.getYear(), week.getMonth(), 1);
                            week = new Week(c, this.start);
                        }
                    } else {
                        int size = Solar.getWeeksOfMonth(week.getYear(), week.getMonth(), this.start);
                        if (size == index) {
                            Solar firstDay = week.getFirstDay();
                            Solar lastDay = firstDay.next(6);
                            week = new Week(lastDay.getYear(), lastDay.getMonth(), lastDay.getDay(), this.start);
                            weekMonth = week.getMonth();
                        } else {
                            c = Kalendar.calendar(week.getYear(), week.getMonth(), Solar.getDaysOfMonth(week.getYear(), week.getMonth()));
                            week = new Week(c, this.start);
                        }
                    }
                    month = weekMonth;
                }
                return week;
            }
            Calendar c = Kalendar.calendar(this.year, this.month, this.day);
            c.add(5, weeks * 7);
            return new Week(c, this.start);
        }

        public Solar getFirstDay() {
            Calendar calendar = Kalendar.calendar(this.year, this.month, this.day);
            int week = calendar.get(7) - 1;
            int prev = week - this.start;
            if (prev < 0) {
                prev += 7;
            }
            calendar.add(5, -prev);
            return new Solar(calendar);
        }

        public Solar getFirstDayInMonth() {
            List<Solar> days = this.getDays();
            for (Solar day : days) {
                if (this.month != day.getMonth()) continue;
                return day;
            }
            return null;
        }

        public List<Solar> getDays() {
            Solar firstDay = this.getFirstDay();
            ArrayList<Solar> l = new ArrayList<Solar>();
            l.add(firstDay);
            for (int i = 1; i < 7; ++i) {
                l.add(firstDay.next(i));
            }
            return l;
        }

        public List<Solar> getDaysInMonth() {
            List<Solar> days = this.getDays();
            ArrayList<Solar> list = new ArrayList<Solar>();
            for (Solar day : days) {
                if (this.month != day.getMonth()) continue;
                list.add(day);
            }
            return list;
        }

        public String build(boolean ... args) {
            if (ObjectKit.isNotEmpty((Object)args) && BooleanKit.and(args)) {
                return this.year + "\u5e74" + this.month + "\u6708\u7b2c" + this.getIndex() + "\u5468";
            }
            return this.year + "." + this.month + "." + this.getIndex();
        }
    }

    public static class Month {
        private final int year;
        private final int month;

        public Month() {
            this(new Date());
        }

        public Month(Date date) {
            Calendar calendar = Kalendar.calendar(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Month(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Month(int year, int month) {
            this.year = year;
            this.month = month;
        }

        public static Month from(Date date) {
            return new Month(date);
        }

        public static Month from(Calendar calendar) {
            return new Month(calendar);
        }

        public static Month from(int year, int month) {
            return new Month(year, month);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public List<Solar> getDays() {
            ArrayList<Solar> list = new ArrayList<Solar>(31);
            Solar solar = new Solar(this.year, this.month, 1);
            list.add(solar);
            int days = Solar.getDaysOfMonth(this.year, this.month);
            for (int i = 1; i < days; ++i) {
                list.add(solar.next(i));
            }
            return list;
        }

        public Month next(int months) {
            Calendar calendar = Kalendar.calendar(this.year, this.month, 1);
            calendar.add(2, months);
            return new Month(calendar);
        }

        public String build(boolean ... args) {
            if (ObjectKit.isNotEmpty((Object)args) && BooleanKit.and(args)) {
                return this.year + "\u5e74" + this.month + "\u6708";
            }
            return this.year + "-" + this.month;
        }
    }

    public static class Quarter {
        public static final int MONTH_COUNT = 3;
        private final int year;
        private final int month;

        public Quarter() {
            this(new Date());
        }

        public Quarter(Date date) {
            Calendar calendar = Kalendar.calendar(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Quarter(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Quarter(int year, int month) {
            this.year = year;
            this.month = month;
        }

        public static Quarter from(Date date) {
            return new Quarter(date);
        }

        public static Quarter from(Calendar calendar) {
            return new Quarter(calendar);
        }

        public static Quarter from(int year, int month) {
            return new Quarter(year, month);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getIndex() {
            return (int)Math.ceil((double)this.month * 1.0 / 3.0);
        }

        public Quarter next(int seasons) {
            if (0 == seasons) {
                return new Quarter(this.year, this.month);
            }
            Calendar calendar = Kalendar.calendar(this.year, this.month, 1);
            calendar.add(2, 3 * seasons);
            return new Quarter(calendar);
        }

        public List<Month> getMonths() {
            ArrayList<Month> list = new ArrayList<Month>();
            int index = this.getIndex() - 1;
            for (int i = 0; i < 3; ++i) {
                list.add(new Month(this.year, 3 * index + i + 1));
            }
            return list;
        }

        public String build(boolean ... args) {
            if (ObjectKit.isNotEmpty((Object)args) && BooleanKit.and(args)) {
                return this.year + "\u5e74" + this.getIndex() + "\u5b63\u5ea6";
            }
            return this.year + "." + this.getIndex();
        }
    }

    public static class Semester {
        public static final int MONTH_COUNT = 6;
        private final int year;
        private final int month;

        public Semester() {
            this(new Date());
        }

        public Semester(Date date) {
            Calendar calendar = Kalendar.calendar(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Semester(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
        }

        public Semester(int year, int month) {
            this.year = year;
            this.month = month;
        }

        public static Semester from(Date date) {
            return new Semester(date);
        }

        public static Semester from(Calendar calendar) {
            return new Semester(calendar);
        }

        public static Semester from(int year, int month) {
            return new Semester(year, month);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getIndex() {
            return (int)Math.ceil((double)this.month * 1.0 / 6.0);
        }

        public Semester next(int halfYears) {
            if (0 == halfYears) {
                return new Semester(this.year, this.month);
            }
            Calendar calendar = Kalendar.calendar(this.year, this.month, 1);
            calendar.add(2, 6 * halfYears);
            return new Semester(calendar);
        }

        public List<Month> getMonths() {
            ArrayList<Month> list = new ArrayList<Month>();
            int index = this.getIndex() - 1;
            for (int i = 0; i < 6; ++i) {
                list.add(new Month(this.year, 6 * index + i + 1));
            }
            return list;
        }

        public String build(boolean ... args) {
            if (ObjectKit.isNotEmpty((Object)args) && BooleanKit.and(args)) {
                return this.year + "\u5e74" + (this.getIndex() == 1 ? "\u4e0a" : "\u4e0b") + "\u534a\u5e74";
            }
            return this.year + "." + this.getIndex();
        }
    }

    public static class Year {
        public static final int MONTH_COUNT = 12;
        private final int year;

        public Year() {
            this(new Date());
        }

        public Year(Date date) {
            Calendar calendar = Kalendar.calendar(date);
            this.year = calendar.get(1);
        }

        public Year(Calendar calendar) {
            this.year = calendar.get(1);
        }

        public Year(int year) {
            this.year = year;
        }

        public static Year from(Date date) {
            return new Year(date);
        }

        public static Year from(Calendar calendar) {
            return new Year(calendar);
        }

        public static Year from(int year) {
            return new Year(year);
        }

        public int getYear() {
            return this.year;
        }

        public List<Month> getMonths() {
            ArrayList<Month> list = new ArrayList<Month>(12);
            Month month = new Month(this.year, 1);
            list.add(month);
            for (int i = 1; i < 12; ++i) {
                list.add(month.next(i));
            }
            return list;
        }

        public Year next(int years) {
            Calendar calendar = Kalendar.calendar(this.year, 1, 1);
            calendar.add(1, years);
            return new Year(calendar);
        }

        public String build(boolean ... args) {
            if (ObjectKit.isNotEmpty((Object)args) && BooleanKit.and(args)) {
                return this.year + "\u5e74";
            }
            return this.year + "";
        }
    }
}

